/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.io.File;
import java.util.ArrayList;
import mobitag.BookFile;
import mobitag.MobiTag;

public final class BookFolder {
    private File bookFolderFile = null;
    private MobiTag.MobiSwingWorker w = null;
    private ArrayList<BookFolder> bookFolders = null;
    private ArrayList<BookFile> bookFiles = null;
    private boolean shouldIShow = true;

    public BookFolder(File bookFolderFile, MobiTag.MobiSwingWorker w) {
        this.w = w;
        this.setBookFolderFile(bookFolderFile, w);
    }

    public String toString() {
        return this.bookFolderFile.getName();
    }

    public File getBookFolderFile() {
        return this.bookFolderFile;
    }

    public void setBookFolderFile(File bookFolderFile, MobiTag.MobiSwingWorker w) {
        this.bookFolderFile = bookFolderFile;
        this.getFolderContent(w);
    }

    public ArrayList<BookFolder> getBookFolders() {
        return this.bookFolders;
    }

    public void setBookFolders(ArrayList<BookFolder> bookFolders) {
        this.bookFolders = bookFolders;
    }

    public ArrayList<BookFile> getBookFiles() {
        return this.bookFiles;
    }

    public void setBookFiles(ArrayList<BookFile> bookFiles) {
        this.bookFiles = bookFiles;
    }

    public void addBookFolder(BookFolder bookFolder, MobiTag.MobiSwingWorker w) {
        if (null == this.bookFolders) {
            this.bookFolders = new ArrayList();
        }
        this.bookFolders.add(bookFolder);
    }

    public void addBookFile(BookFile bookFile) {
        if (null == this.bookFiles) {
            this.bookFiles = new ArrayList();
        }
        this.bookFiles.add(bookFile);
    }

    private void getFolderContent(MobiTag.MobiSwingWorker w) {
        if (null != this.bookFolderFile) {
            for (File file : this.bookFolderFile.listFiles()) {
                if (file.isDirectory()) {
                    this.addBookFolder(new BookFolder(file, w), w);
                    continue;
                }
                if (!file.getName().endsWith("mobi")) continue;
                this.addBookFile(new BookFile(file));
                MobiTag.splashUpdate();
                if (null == w) continue;
                w.readAnotherBook();
            }
        }
    }

    public boolean shouldIShow(ArrayList<String> currentTags) {
        this.shouldIShow = this.showingChildFolders(currentTags) || this.showingChildBooks(currentTags);
        return this.shouldIShow;
    }

    private boolean showingChildFolders(ArrayList<String> currentTags) {
        boolean showing = false;
        for (int i = 0; null != this.bookFolders && !showing && i < this.bookFolders.size(); ++i) {
            BookFolder bf = this.bookFolders.get(i);
            showing = bf.shouldIShow(currentTags);
        }
        return showing;
    }

    private boolean showingChildBooks(ArrayList<String> currentTags) {
        boolean showing = false;
        for (int i = 0; null != this.bookFiles && !showing && i < this.bookFiles.size(); ++i) {
            BookFile bf = this.bookFiles.get(i);
            showing = bf.shouldIShow(currentTags);
        }
        return showing;
    }
}

