/*
 * Decompiled with CFR 0.152.
 */
package mobitag;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import mobimeta.EXTHHeader;
import mobimeta.EXTHRecord;
import mobimeta.MobiMeta;
import mobitag.Counter;
import mobitag.Props;
import mobitag.RecordTypeChange;
import mobitag.Utils;

public final class BookFile {
    private File bookFile = null;
    boolean show = false;
    private MobiMeta mobiMeta = null;

    public BookFile(File bookFile) {
        this.setBookFile(bookFile);
        Counter.addBook();
    }

    public ArrayList<String> getTags() {
        ArrayList<String> tags = null;
        if (null == this.mobiMeta) {
            try {
                this.mobiMeta = new MobiMeta(this.bookFile);
                tags = this.mobiMeta.getMobiHeader().getEXTHHeader().getTagsAsArrayList();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error was encountered retrieving the tags for the book '" + this.bookFile.getAbsolutePath() + "'. The exception was '" + e.getMessage() + "'. The application will proceed, acting as if the book had no tags.", "MobiTag", 0, Utils.getImg());
            }
        } else {
            tags = this.mobiMeta.getMobiHeader().getEXTHHeader().getTagsAsArrayList();
        }
        return tags;
    }

    public MobiMeta getMobiMeta() {
        return this.mobiMeta;
    }

    public List<EXTHRecord> getEXTHRecords() {
        return this.mobiMeta.getMobiHeader().getEXTHHeader().getRecordList();
    }

    public String getShortName() {
        String name = this.bookFile.getName();
        if (name.endsWith(".mobi")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    public String toString() {
        return this.getShortName();
    }

    public File getBookFile() {
        return this.bookFile;
    }

    public boolean storeChanges(ArrayList<RecordTypeChange> changes) {
        boolean ok = true;
        boolean found = false;
        EXTHHeader exthHeader = this.mobiMeta.getMobiHeader().getEXTHHeader();
        if (null != changes) {
            for (int i = 0; i < changes.size(); ++i) {
                RecordTypeChange change = changes.get(i);
                if (change.getDelete()) {
                    exthHeader.removeRecordsWithType(change.getType());
                    continue;
                }
                found = exthHeader.setAllRecordsWithTypeToString(change.getType(), change.getValue(), null);
                if (found) continue;
                exthHeader.addRecord(change.getType(), change.getValue(), null);
            }
            try {
                this.mobiMeta.saveToNewFile(this.bookFile.getAbsoluteFile());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error was encountered saving the changes to the book \r\n'" + this.bookFile.getAbsolutePath() + "'.\r\nThe exception was\r\n'" + e.getMessage() + "'.\r\nThe changes to the book cannot be saved at this time.", "MobiTag", 0, Utils.getImg());
            }
        }
        return ok;
    }

    public void setBookFile(File bookFile) {
        this.bookFile = bookFile;
    }

    public void setTags(ArrayList<String> tags) {
        this.setBookFileTags(tags);
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    private void setBookFileTags(ArrayList<String> tags) {
        String tagString = null;
        if (null == tags) {
            tagString = "";
        } else {
            for (int i = 0; null != tags && i < tags.size(); ++i) {
                tagString = null == tagString ? tags.get(i) : tagString + ";" + tags.get(i);
            }
        }
        if (null != tagString) {
            ArrayList<RecordTypeChange> changes = new ArrayList<RecordTypeChange>();
            changes.add(new RecordTypeChange(105, tagString, false));
            this.storeChanges(changes);
            this.mobiMeta.getMobiHeader().getEXTHHeader().setTags(tagString);
        }
    }

    public void deleteBookFileTags() {
        ArrayList<RecordTypeChange> changes = new ArrayList<RecordTypeChange>();
        changes.add(new RecordTypeChange(105, "", false));
        this.storeChanges(changes);
        this.mobiMeta.getMobiHeader().getEXTHHeader().setTags(null);
    }

    public void dumpBookFile() {
        this.mobiMeta.getPDBHeader().dumpHeader();
        this.mobiMeta.getMobiHeader().dumpHeader();
        this.mobiMeta.getMobiHeader().getEXTHHeader().dumpHeader();
    }

    public boolean shouldIShow(ArrayList<String> currentTags) {
        ArrayList<String> tags = this.mobiMeta.getMobiHeader().getEXTHHeader().getTagsAsArrayList();
        boolean match = false;
        int showProp = Props.getShowBooksNoTags();
        int andOrTags = Props.getAndOrTags();
        if (null != tags && 0 < tags.size()) {
            if (0 == andOrTags) {
                if (null != currentTags) {
                    for (int i = 0; !match && i < tags.size(); ++i) {
                        String tag = tags.get(i).trim();
                        for (int k = 0; !match && k < currentTags.size(); ++k) {
                            String tagListTag = currentTags.get(k).trim();
                            match = tag.equalsIgnoreCase(tagListTag);
                        }
                    }
                } else {
                    match = true;
                }
            } else if (1 == andOrTags) {
                match = null != currentTags ? currentTags.containsAll(tags) : true;
            } else if (2 == andOrTags) {
                match = null != currentTags ? tags.containsAll(currentTags) : true;
            } else {
                match = true;
                JOptionPane.showMessageDialog(null, "An invalid property for the andOrTags property of '" + andOrTags + "' was encountered. The application will proceed assuming the book is to be shown.", "MobiTag", 0, Utils.getImg());
            }
        } else if (0 == showProp) {
            match = true;
        } else if (1 == showProp) {
            match = false;
        } else if (2 == showProp) {
            match = currentTags == null || 0 == currentTags.size();
        } else {
            match = true;
            JOptionPane.showMessageDialog(null, "An invalid property for the showBooksNoTags property of '" + showProp + "' was encountered. The application will proceed assuming the book is to be shown.", "MobiTag", 0, Utils.getImg());
        }
        return match;
    }
}

