/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import mobitag.Utils;

public class StreamUtils {
    public static byte readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            Utils.log("StreamUtils.readByte: Supposed to read a byte, but could not", 3);
            throw new IOException("Supposed to read a byte, but could not");
        }
        return (byte)(b & 0xFF);
    }

    public static void readByteArray(InputStream in, byte[] buffer) throws IOException {
        int len;
        int bytesRead;
        int offset = 0;
        for (int bytesLeft = len = buffer.length; bytesLeft > 0; bytesLeft -= bytesRead) {
            bytesRead = in.read(buffer, offset, bytesLeft);
            if (bytesRead == -1) {
                Utils.log("StreamUtils.readByteArray: Supposed to read a '" + len + "' byte array, but could not", 3);
                throw new IOException("Supposed to read a " + len + " byte array, but could not");
            }
            offset += bytesRead;
        }
    }

    public static String byteArrayToString(byte[] buffer) {
        return StreamUtils.byteArrayToString(buffer, null);
    }

    public static String byteArrayToString(byte[] buffer, String encoding) {
        int len = buffer.length;
        int zeroIndex = -1;
        for (int i = 0; i < len; ++i) {
            byte b = buffer[i];
            if (b != 0) continue;
            zeroIndex = i;
            break;
        }
        if (encoding != null) {
            try {
                if (zeroIndex == -1) {
                    return new String(buffer, encoding);
                }
                return new String(buffer, 0, zeroIndex, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (zeroIndex == -1) {
            return new String(buffer);
        }
        return new String(buffer, 0, zeroIndex);
    }

    public static int byteToInt(byte buffer) {
        int total = buffer & 0xFF;
        return total;
    }

    public static int byteArrayToInt(byte[] buffer) {
        int total = 0;
        int len = buffer.length;
        for (int i = 0; i < len; ++i) {
            total = (total << 8) + (buffer[i] & 0xFF);
        }
        return total;
    }

    public static long byteArrayToLong(byte[] buffer) {
        long total = 0L;
        int len = buffer.length;
        for (int i = 0; i < len; ++i) {
            total = (total << 8) + (long)(buffer[i] & 0xFF);
        }
        return total;
    }

    public static void intToByteArray(int value, byte[] dest) {
        int lastIndex;
        for (int i = lastIndex = dest.length - 1; i >= 0; --i) {
            dest[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public static void longToByteArray(long value, byte[] dest) {
        int lastIndex;
        for (int i = lastIndex = dest.length - 1; i >= 0; --i) {
            dest[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    public static byte[] stringToByteArray(String s) {
        return StreamUtils.stringToByteArray(s, null);
    }

    public static byte[] stringToByteArray(String s, String encoding) {
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }

    public static String dumpByte(byte buffer) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(buffer & 0xFF);
        sb.append("}");
        return sb.toString();
    }

    public static String dumpByteArray(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int len = buffer.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(buffer[i] & 0xFF);
        }
        sb.append("}");
        return sb.toString();
    }
}

