/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mobimeta.StreamUtils;

public class RecordInfo {
    private byte[] recordDataOffset = new byte[]{0, 0, 0, 0};
    private byte recordAttributes = 0;
    private byte[] uniqueID = new byte[]{0, 0, 0};

    public RecordInfo(InputStream in) throws IOException {
        StreamUtils.readByteArray(in, this.recordDataOffset);
        this.recordAttributes = StreamUtils.readByte(in);
        StreamUtils.readByteArray(in, this.uniqueID);
    }

    public byte[] getRecordDataOffsetAsByteArray() {
        return this.recordDataOffset;
    }

    public byte getRecordAttributes() {
        return this.recordAttributes;
    }

    public byte[] getUniqueID() {
        return this.uniqueID;
    }

    public long getRecordDataOffset() {
        return StreamUtils.byteArrayToLong(this.recordDataOffset);
    }

    public void setRecordDataOffset(long newOffset) {
        StreamUtils.longToByteArray(newOffset, this.recordDataOffset);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.recordDataOffset);
        out.write(this.recordAttributes);
        out.write(this.uniqueID);
    }
}

