/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import mobimeta.RecordInfo;
import mobimeta.StreamUtils;

public class PDBHeader {
    private byte[] name = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] attributes = new byte[]{0, 0};
    private byte[] version = new byte[]{0, 0};
    private byte[] creationDate = new byte[]{0, 0, 0, 0};
    private byte[] modificationDate = new byte[]{0, 0, 0, 0};
    private byte[] lastBackupDate = new byte[]{0, 0, 0, 0};
    private byte[] modificationNumber = new byte[]{0, 0, 0, 0};
    private byte[] appInfoID = new byte[]{0, 0, 0, 0};
    private byte[] sortInfoID = new byte[]{0, 0, 0, 0};
    private byte[] type = new byte[]{0, 0, 0, 0};
    private byte[] creator = new byte[]{0, 0, 0, 0};
    private byte[] uniqueIDSeed = new byte[]{0, 0, 0, 0};
    private byte[] nextRecordListID = new byte[]{0, 0, 0, 0};
    private byte[] numRecords = new byte[]{0, 0};
    private List<RecordInfo> recordInfoList;
    private byte[] gapToData = new byte[]{0, 0};

    public PDBHeader(InputStream in) throws IOException {
        StreamUtils.readByteArray(in, this.name);
        StreamUtils.readByteArray(in, this.attributes);
        StreamUtils.readByteArray(in, this.version);
        StreamUtils.readByteArray(in, this.creationDate);
        StreamUtils.readByteArray(in, this.modificationDate);
        StreamUtils.readByteArray(in, this.lastBackupDate);
        StreamUtils.readByteArray(in, this.modificationNumber);
        StreamUtils.readByteArray(in, this.appInfoID);
        StreamUtils.readByteArray(in, this.sortInfoID);
        StreamUtils.readByteArray(in, this.type);
        StreamUtils.readByteArray(in, this.creator);
        StreamUtils.readByteArray(in, this.uniqueIDSeed);
        StreamUtils.readByteArray(in, this.nextRecordListID);
        StreamUtils.readByteArray(in, this.numRecords);
        int recordCount = StreamUtils.byteArrayToInt(this.numRecords);
        this.recordInfoList = new LinkedList<RecordInfo>();
        for (int i = 0; i < recordCount; ++i) {
            this.recordInfoList.add(new RecordInfo(in));
        }
        StreamUtils.readByteArray(in, this.gapToData);
    }

    public long getMobiHeaderSize() {
        return this.recordInfoList.size() > 1 ? this.recordInfoList.get(1).getRecordDataOffset() - this.recordInfoList.get(0).getRecordDataOffset() : 0L;
    }

    public long getOffsetAfterMobiHeader() {
        return this.recordInfoList.size() > 1 ? this.recordInfoList.get(1).getRecordDataOffset() : 0L;
    }

    public void adjustOffsetsAfterMobiHeader(int newMobiHeaderSize) {
        if (this.recordInfoList.size() < 2) {
            return;
        }
        int delta = (int)((long)newMobiHeaderSize - this.getMobiHeaderSize());
        int len = this.recordInfoList.size();
        for (int i = 1; i < len; ++i) {
            RecordInfo rec = this.recordInfoList.get(i);
            long oldOffset = rec.getRecordDataOffset();
            rec.setRecordDataOffset(oldOffset + (long)delta);
        }
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.name);
        out.write(this.attributes);
        out.write(this.version);
        out.write(this.creationDate);
        out.write(this.modificationDate);
        out.write(this.lastBackupDate);
        out.write(this.modificationNumber);
        out.write(this.appInfoID);
        out.write(this.sortInfoID);
        out.write(this.type);
        out.write(this.creator);
        out.write(this.uniqueIDSeed);
        out.write(this.nextRecordListID);
        out.write(this.numRecords);
        for (RecordInfo rec : this.recordInfoList) {
            rec.write(out);
        }
        out.write(this.gapToData);
    }

    public String getName() {
        return StreamUtils.byteArrayToString(this.name);
    }

    public int getAttributes() {
        return StreamUtils.byteArrayToInt(this.attributes);
    }

    public int getVersion() {
        return StreamUtils.byteArrayToInt(this.version);
    }

    public long getCreationDate() {
        return StreamUtils.byteArrayToLong(this.creationDate);
    }

    public long getModificationDate() {
        return StreamUtils.byteArrayToLong(this.modificationDate);
    }

    public long getLastBackupDate() {
        return StreamUtils.byteArrayToLong(this.lastBackupDate);
    }

    public long getModificationNumber() {
        return StreamUtils.byteArrayToLong(this.modificationNumber);
    }

    public long getAppInfoID() {
        return StreamUtils.byteArrayToLong(this.appInfoID);
    }

    public long getSortInfoID() {
        return StreamUtils.byteArrayToLong(this.sortInfoID);
    }

    public long getType() {
        return StreamUtils.byteArrayToLong(this.type);
    }

    public long getCreator() {
        return StreamUtils.byteArrayToLong(this.creator);
    }

    public long getUniqueIDSeed() {
        return StreamUtils.byteArrayToLong(this.uniqueIDSeed);
    }

    public void dumpHeader() {
        String dump = null;
        dump = "-----------------------------------------------\r\nPDBHeader\r\n\tname - " + StreamUtils.dumpByteArray(this.name) + " '" + StreamUtils.byteArrayToString(this.name) + "'\r\n" + "\tattributes - " + StreamUtils.dumpByteArray(this.attributes) + "\r\n" + "\tversion - " + StreamUtils.dumpByteArray(this.version) + " '" + StreamUtils.byteArrayToInt(this.version) + "'\r\n" + "\tcreationDate - " + StreamUtils.dumpByteArray(this.creationDate) + " '" + StreamUtils.byteArrayToInt(this.creationDate) + "'\r\n" + "\tmodificationDate - " + StreamUtils.dumpByteArray(this.modificationDate) + " '" + StreamUtils.byteArrayToInt(this.modificationDate) + "'\r\n" + "\tlastBackupDate - " + StreamUtils.dumpByteArray(this.lastBackupDate) + " '" + StreamUtils.byteArrayToInt(this.lastBackupDate) + "'\r\n" + "\tmodificationNumber - " + StreamUtils.dumpByteArray(this.modificationNumber) + " '" + StreamUtils.byteArrayToInt(this.modificationNumber) + "'\r\n" + "\tappInfoID - " + StreamUtils.dumpByteArray(this.appInfoID) + " '" + StreamUtils.byteArrayToInt(this.appInfoID) + "'\r\n" + "\tsortInfoID - " + StreamUtils.dumpByteArray(this.sortInfoID) + " '" + StreamUtils.byteArrayToInt(this.sortInfoID) + "'\r\n" + "\ttype - " + StreamUtils.dumpByteArray(this.type) + " '" + StreamUtils.byteArrayToString(this.type) + "'\r\n" + "\tcreator - " + StreamUtils.dumpByteArray(this.creator) + " '" + StreamUtils.byteArrayToString(this.creator) + "'\r\n" + "\tuniqueIDSeed - " + StreamUtils.dumpByteArray(this.uniqueIDSeed) + " '" + StreamUtils.byteArrayToInt(this.uniqueIDSeed) + "'\r\n" + "\tnextRecordListID - " + StreamUtils.dumpByteArray(this.nextRecordListID) + " '" + StreamUtils.byteArrayToInt(this.nextRecordListID) + "'\r\n" + "\tnumRecords - " + StreamUtils.dumpByteArray(this.numRecords) + " '" + StreamUtils.byteArrayToInt(this.numRecords) + "'\r\n";
        if (null != this.recordInfoList) {
            dump = dump + "\tnon-null recordInfoList, with " + this.recordInfoList.size() + " records\r\n";
            for (int i = 0; i < this.recordInfoList.size(); ++i) {
                RecordInfo ri = this.recordInfoList.get(i);
                dump = dump + "\t\trecordInfo[" + i + "]\r\n";
                dump = dump + "\t\t\trecordDataOffset - " + StreamUtils.dumpByteArray(ri.getRecordDataOffsetAsByteArray()) + " '" + StreamUtils.byteArrayToLong(ri.getRecordDataOffsetAsByteArray()) + "'";
                dump = dump + "\r\n\t\t\trecordAttributes - " + StreamUtils.dumpByte(ri.getRecordAttributes());
                dump = dump + "\r\n\t\t\tUniqueID - " + StreamUtils.dumpByteArray(ri.getUniqueID()) + " '" + StreamUtils.byteArrayToLong(ri.getUniqueID()) + "'\r\n";
            }
        } else {
            dump = dump + "\tnull recordInfoList";
        }
        System.out.println(dump);
    }

    public String dump(byte[] b, String name) {
        String result = null;
        result = name + " - " + StreamUtils.dumpByteArray(b) + "\r\n\t\t'" + StreamUtils.byteArrayToString(b) + "'\r\n";
        return result;
    }
}

