/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import mobimeta.MobiHeader;
import mobimeta.MobiMetaException;
import mobimeta.PDBHeader;
import mobitag.Props;
import mobitag.Utils;

public class MobiMeta {
    public static final int BUFFER_SIZE = 4096;
    protected PDBHeader pdbHeader;
    protected MobiHeader mobiHeader;
    protected String characterEncoding;
    private File inputFile;

    public MobiMeta(File f) throws MobiMetaException {
        this.inputFile = f;
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            this.pdbHeader = new PDBHeader(in);
            this.mobiHeader = new MobiHeader(in, this.pdbHeader.getMobiHeaderSize());
            this.characterEncoding = this.mobiHeader.getCharacterEncoding();
        }
        catch (IOException e) {
            throw new MobiMetaException("Could not parse mobi file " + f.getAbsolutePath() + ": " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Utils.log("MobiMeta.MobiMeta: Exception '" + e.getMessage() + "' generated closing input file '" + f.getAbsolutePath() + ".", 2);
                }
            }
        }
    }

    public PDBHeader getPDBHeader() {
        return this.pdbHeader;
    }

    public MobiHeader getMobiHeader() {
        return this.mobiHeader;
    }

    public void saveToNewFile(File outputFile) throws IOException {
        File tempFile = new File(outputFile.getAbsolutePath() + "_temp");
        if (Props.getBackupOriginal()) {
            boolean backupFileFound = false;
            String backupFileName = null;
            int counter = 1;
            File backupFile = null;
            while (!backupFileFound) {
                backupFileName = outputFile.getAbsolutePath() + "_backup_" + counter;
                backupFile = new File(backupFileName);
                if (!backupFile.exists()) {
                    backupFileFound = true;
                    continue;
                }
                ++counter;
            }
            try {
                Files.copy(outputFile.toPath(), backupFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                Utils.log("MobiMeta.saveToNewFile: Exception '" + e.getMessage() + "' generated copying outputFile '" + outputFile.getAbsolutePath() + "' to backupFile '" + backupFile.getAbsolutePath() + "'.", 3);
                throw new IOException("Exception '" + e.getMessage() + "' generated copying outputFile '" + outputFile.getAbsolutePath() + "' to backupFile '" + backupFile.getAbsolutePath() + "'.");
            }
        }
        this.saveToNewFile(tempFile, true);
        try {
            Files.copy(tempFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            Utils.log("MobiMeta.saveToNewFile: Exception '" + e.getMessage() + "' generated copying tempFile '" + tempFile.getAbsolutePath() + "' to outputFile '" + outputFile.getAbsolutePath() + "'.", 3);
            throw new IOException("Exception '" + e.getMessage() + "' generated copying tempFile '" + outputFile.getAbsolutePath() + "' to outputFile '" + outputFile.getAbsolutePath() + "'.");
        }
        tempFile.delete();
    }

    public void saveToNewFile(File outputFile, boolean packHeader) throws IOException {
        long readOffset = this.pdbHeader.getOffsetAfterMobiHeader();
        if (packHeader) {
            this.mobiHeader.pack();
            this.pdbHeader.adjustOffsetsAfterMobiHeader(this.mobiHeader.size());
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(outputFile);
            this.pdbHeader.write(out);
            this.mobiHeader.write(out);
            byte[] buffer = new byte[4096];
            in = new FileInputStream(this.inputFile);
            in.skip(readOffset);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            Utils.log("MobiMeta.saveToNewFile: Exception '" + e.getMessage() + "' generated reading/writing data from source file '" + this.inputFile.getAbsolutePath() + "' to destination file '" + outputFile.getAbsolutePath() + "'.", 3);
            throw new IOException("Exception '" + e.getMessage() + "' generated reading/writing data from source file '" + this.inputFile.getAbsolutePath() + "' to destination file '" + outputFile.getAbsolutePath() + "'.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Utils.log("MobiMeta.saveToNewFile: Exception '" + e.getMessage() + "' generated closing the source file '" + this.inputFile.getAbsolutePath() + "'.", 2);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Utils.log("MobiMeta.saveToNewFile: Exception '" + e.getMessage() + "' generated closing the destination file '" + outputFile.getAbsolutePath() + "'.", 2);
                }
            }
        }
    }

    public String getCharacterEncoding() {
        return this.mobiHeader.getCharacterEncoding();
    }

    public String getFullName() {
        return this.mobiHeader.getFullName();
    }

    public void setFullName(String s) {
        this.mobiHeader.setFullName(s);
    }

    public int getLocale() {
        return this.mobiHeader.getLocale();
    }

    public int getDictInput() {
        return this.mobiHeader.getInputLanguage();
    }

    public int getDictOutput() {
        return this.mobiHeader.getOutputLanguage();
    }

    public void setLanguages(int locale, int dictInput, int dictOutput) {
        this.mobiHeader.setLocale(locale);
        this.mobiHeader.setInputLanguage(dictInput);
        this.mobiHeader.setOutputLanguage(dictOutput);
    }

    public String getMetaInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("PDB Header\r\n----------\r\nName: ");
        sb.append(this.pdbHeader.getName());
        sb.append("\r\n");
        String[] attributes = this.getPDBHeaderAttributes();
        if (attributes.length > 0) {
            sb.append("Attributes: ");
            for (int i = 0; i < attributes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(attributes[i]);
            }
            sb.append("\r\n");
        }
        sb.append("Version: ");
        sb.append(this.pdbHeader.getVersion());
        sb.append("\r\nCreation Date: ");
        sb.append(this.pdbHeader.getCreationDate());
        sb.append("\r\nModification Date: ");
        sb.append(this.pdbHeader.getModificationDate());
        sb.append("\r\nLast Backup Date: ");
        sb.append(this.pdbHeader.getLastBackupDate());
        sb.append("\r\nModification Number: ");
        sb.append(this.pdbHeader.getModificationNumber());
        sb.append("\r\nApp Info ID: ");
        sb.append(this.pdbHeader.getAppInfoID());
        sb.append("\r\nSort Info ID: ");
        sb.append(this.pdbHeader.getSortInfoID());
        sb.append("\r\nType: ");
        sb.append(this.pdbHeader.getType());
        sb.append("\r\nCreator: ");
        sb.append(this.pdbHeader.getCreator());
        sb.append("\r\nUnique ID Seed: ");
        sb.append(this.pdbHeader.getUniqueIDSeed());
        sb.append("\r\n\r\nPalmDOC Header\r\n--------------\r\nCompression: ");
        sb.append(this.mobiHeader.getCompression());
        sb.append("\r\nText Length: ");
        sb.append(this.mobiHeader.getTextLength());
        sb.append("\r\nRecord Count: ");
        sb.append(this.mobiHeader.getRecordCount());
        sb.append("\r\nRecord Size: ");
        sb.append(this.mobiHeader.getRecordSize());
        sb.append("\r\nEncryption Type: ");
        sb.append(this.mobiHeader.getEncryptionType());
        sb.append("\r\n\r\nMOBI Header\r\n-----------\r\nHeader Length: ");
        sb.append(this.mobiHeader.getHeaderLength());
        sb.append("\r\nMobi Type: ");
        sb.append(this.mobiHeader.getMobiType());
        sb.append("\r\nUnique ID: ");
        sb.append(this.mobiHeader.getUniqueID());
        sb.append("\r\nFile Version: ");
        sb.append(this.mobiHeader.getFileVersion());
        sb.append("\r\nOrthographic Index: ");
        sb.append(this.mobiHeader.getOrthographicIndex());
        sb.append("\r\nInflection Index: ");
        sb.append(this.mobiHeader.getInflectionIndex());
        sb.append("\r\nIndex Names: ");
        sb.append(this.mobiHeader.getIndexNames());
        sb.append("\r\nIndex Keys: ");
        sb.append(this.mobiHeader.getIndexKeys());
        sb.append("\r\nExtra Index 0: ");
        sb.append(this.mobiHeader.getExtraIndex0());
        sb.append("\r\nExtra Index 1: ");
        sb.append(this.mobiHeader.getExtraIndex1());
        sb.append("\r\nExtra Index 2: ");
        sb.append(this.mobiHeader.getExtraIndex2());
        sb.append("\r\nExtra Index 3: ");
        sb.append(this.mobiHeader.getExtraIndex3());
        sb.append("\r\nExtra Index 4: ");
        sb.append(this.mobiHeader.getExtraIndex4());
        sb.append("\r\nExtra Index 5: ");
        sb.append(this.mobiHeader.getExtraIndex5());
        sb.append("\r\nFirst Non-Book Index: ");
        sb.append(this.mobiHeader.getFirstNonBookIndex());
        sb.append("\r\nFull Name Offset: ");
        sb.append(this.mobiHeader.getFullNameOffset());
        sb.append("\r\nFull Name Length: ");
        sb.append(this.mobiHeader.getFullNameLength());
        sb.append("\r\nMin Version: ");
        sb.append(this.mobiHeader.getMinVersion());
        sb.append("\r\nHuffman Record Offset: ");
        sb.append(this.mobiHeader.getHuffmanRecordOffset());
        sb.append("\r\nHuffman Record Count: ");
        sb.append(this.mobiHeader.getHuffmanRecordCount());
        sb.append("\r\nHuffman Table Offset: ");
        sb.append(this.mobiHeader.getHuffmanTableOffset());
        sb.append("\r\nHuffman Table Length: ");
        sb.append(this.mobiHeader.getHuffmanTableLength());
        sb.append("\r\n");
        return sb.toString();
    }

    private String[] getPDBHeaderAttributes() {
        LinkedList<String> list = new LinkedList<String>();
        int attr = this.pdbHeader.getAttributes();
        if ((attr & 2) != 0) {
            list.add("Read-Only");
        }
        if ((attr & 4) != 0) {
            list.add("Dirty AppInfoArea");
        }
        if ((attr & 8) != 0) {
            list.add("Backup This Database");
        }
        if ((attr & 0x10) != 0) {
            list.add("OK To Install Newer Over Existing Copy");
        }
        if ((attr & 0x20) != 0) {
            list.add("Force The PalmPilot To Reset After This Database Is Installed");
        }
        if ((attr & 0x40) != 0) {
            list.add("Don't Allow Copy Of File To Be Beamed To Other Pilot");
        }
        String[] ret = new String[list.size()];
        int index = 0;
        for (String s : list) {
            ret[index++] = s;
        }
        return ret;
    }
}

