/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import mobimeta.StreamUtils;
import mobitag.Utils;

public class EXTHRecord {
    public static final int[] booleanTypes;
    public static final int[] knownTypes;
    public static final String[] knownDesc;
    private static HashMap<Integer, String> typeHash;
    private static HashSet<Integer> booleanTypesSet;
    private byte[] recordType = new byte[]{0, 0, 0, 0};
    private byte[] recordLength = new byte[]{0, 0, 0, 0};
    private byte[] recordData = null;

    public EXTHRecord(int recType, boolean data) {
        StreamUtils.intToByteArray(recType, this.recordType);
        this.recordData = new byte[1];
        this.recordData[0] = data ? (byte)1 : 0;
        StreamUtils.intToByteArray(this.size(), this.recordLength);
    }

    public EXTHRecord(int recType, byte[] data) {
        StreamUtils.intToByteArray(recType, this.recordType);
        int len = data == null ? 0 : data.length;
        StreamUtils.intToByteArray(len + 8, this.recordLength);
        this.recordData = new byte[len];
        if (len > 0) {
            System.arraycopy(data, 0, this.recordData, 0, len);
        }
    }

    public EXTHRecord(InputStream in) throws IOException {
        StreamUtils.readByteArray(in, this.recordType);
        StreamUtils.readByteArray(in, this.recordLength);
        int len = StreamUtils.byteArrayToInt(this.recordLength);
        if (len < 8) {
            Utils.log("EXTHRecord.EXTHRecord: Invalid EXTH record length of '" + len + "'.", 3);
            throw new IOException("Invalid EXTH record length");
        }
        this.recordData = new byte[len - 8];
        StreamUtils.readByteArray(in, this.recordData);
        int recType = StreamUtils.byteArrayToInt(this.recordType);
        Utils.log("EXTHRecord.EXTHRecord: " + Utils.getRecordTypeString(recType) + " - " + StreamUtils.byteArrayToString(this.recordData), 1);
    }

    public EXTHRecord(int recType, String data, String characterEncoding) {
        this(recType, StreamUtils.stringToByteArray(data, characterEncoding));
    }

    public byte[] getRecordTypeAsByteArray() {
        return this.recordType;
    }

    public byte[] getRecordLengthAsByteArray() {
        return this.recordLength;
    }

    public byte[] getRecordDataAsByteArray() {
        return this.recordData;
    }

    public int getRecordTypeAsInt() {
        return StreamUtils.byteArrayToInt(this.recordType);
    }

    public String getRecordTypeAsIntString() {
        return String.valueOf(StreamUtils.byteArrayToInt(this.recordType));
    }

    public int getRecordDataLength() {
        return this.recordData.length;
    }

    public String getRecordDataAsString() {
        return StreamUtils.byteArrayToString(this.recordData);
    }

    public int size() {
        return this.getRecordDataLength() + 8;
    }

    public void setRecordDataToByteArray(byte[] buffer) {
        this.recordData = buffer;
        StreamUtils.intToByteArray(this.size(), this.recordLength);
    }

    public void setRecordDataToString(String s, String encoding) {
        this.recordData = StreamUtils.stringToByteArray(s, encoding);
        StreamUtils.intToByteArray(this.size(), this.recordLength);
    }

    public EXTHRecord copy() {
        return new EXTHRecord(StreamUtils.byteArrayToInt(this.recordType), this.recordData);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.recordType);
        out.write(this.recordLength);
        out.write(this.recordData);
    }

    static {
        int i;
        booleanTypes = new int[]{404};
        knownTypes = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 118, 119, 200, 404, 501, 503, 504};
        knownDesc = new String[]{"author", "publisher", "imprint", "description", "ISBN", "subject", "publishing date", "review", "contributor", "rights", "subject code", "type", "source", "ASIN", "version number", "retail price", "retail price currency", "dictionary short name", "TTS off", "CDE type", "updated title", "ASIN"};
        typeHash = new HashMap(knownTypes.length);
        for (i = 0; i < knownTypes.length; ++i) {
            String string = typeHash.put(knownTypes[i], knownDesc[i]);
        }
        booleanTypesSet = new HashSet(booleanTypes.length);
        for (i = 0; i < booleanTypes.length; ++i) {
            booleanTypesSet.add(booleanTypes[i]);
        }
    }
}

