/*
 * Decompiled with CFR 0.152.
 */
package mobimeta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mobimeta.EXTHRecord;
import mobimeta.StreamUtils;
import mobitag.Utils;

public class EXTHHeader {
    private byte[] identifier = new byte[]{69, 88, 84, 72};
    private byte[] headerLength = new byte[]{0, 0, 0, 0};
    private byte[] recordCount = new byte[]{0, 0, 0, 0};
    private List<EXTHRecord> recordList = null;

    public EXTHHeader() {
        this.recordList = new LinkedList<EXTHRecord>();
    }

    public EXTHHeader(List<EXTHRecord> list) {
        this.setRecordList(list);
    }

    public EXTHHeader(InputStream in) throws IOException {
        StreamUtils.readByteArray(in, this.identifier);
        if (this.identifier[0] != 69 || this.identifier[1] != 88 || this.identifier[2] != 84 || this.identifier[3] != 72) {
            Utils.log("EXTHHeader.EXTHHeader: Expected to find EXTH header identifier EXTH but got something else instead", 3);
            throw new IOException("Expected to find EXTH header identifier EXTH but got something else instead");
        }
        StreamUtils.readByteArray(in, this.headerLength);
        StreamUtils.readByteArray(in, this.recordCount);
        int count = StreamUtils.byteArrayToInt(this.recordCount);
        this.recordList = new LinkedList<EXTHRecord>();
        for (int i = 0; i < count; ++i) {
            this.recordList.add(new EXTHRecord(in));
        }
        int padding = this.paddingSize(this.dataSize());
        for (int i = 0; i < padding; ++i) {
            StreamUtils.readByte(in);
        }
    }

    public int size() {
        int dataSize = this.dataSize();
        return 12 + dataSize + this.paddingSize(dataSize);
    }

    public void recomputeFields() {
        StreamUtils.intToByteArray(this.size(), this.headerLength);
        StreamUtils.intToByteArray(this.recordList.size(), this.recordCount);
    }

    public String getTagsAsString() {
        String tagString = null;
        int count = StreamUtils.byteArrayToInt(this.recordCount);
        for (int i = 0; i < count && null == tagString; ++i) {
            EXTHRecord record = this.recordList.get(i);
            if (105 != record.getRecordTypeAsInt()) continue;
            tagString = StreamUtils.byteArrayToString(record.getRecordDataAsByteArray());
        }
        return tagString;
    }

    public ArrayList<String> getTagsAsArrayList() {
        String tagString = null;
        ArrayList<String> tags = null;
        int count = StreamUtils.byteArrayToInt(this.recordCount);
        for (int i = 0; i < count && null == tagString; ++i) {
            String[] tokens;
            EXTHRecord record = this.recordList.get(i);
            if (105 != record.getRecordTypeAsInt()) continue;
            tagString = StreamUtils.byteArrayToString(record.getRecordDataAsByteArray());
            for (String token : tokens = tagString.split(";")) {
                if (null == token || 0 >= token.length()) continue;
                if (null == tags) {
                    tags = new ArrayList<String>();
                }
                tags.add(token.trim());
            }
        }
        return tags;
    }

    public void setTags(String tagString) {
        int count = StreamUtils.byteArrayToInt(this.recordCount);
        for (int i = 0; i < count; ++i) {
            EXTHRecord record = this.recordList.get(i);
            if (105 != record.getRecordTypeAsInt()) continue;
            if (null != tagString) {
                record.setRecordDataToString(tagString, null);
            } else {
                record.setRecordDataToByteArray(new byte[]{0, 0, 0, 0});
            }
            this.recomputeFields();
        }
    }

    public List<EXTHRecord> getRecordList() {
        LinkedList<EXTHRecord> list = new LinkedList<EXTHRecord>();
        for (EXTHRecord rec : this.recordList) {
            list.add(rec.copy());
        }
        return list;
    }

    public void setRecordList(List<EXTHRecord> list) {
        this.recordList = new LinkedList<EXTHRecord>();
        if (list != null) {
            for (EXTHRecord rec : list) {
                this.recordList.add(rec.copy());
            }
        }
        this.recomputeFields();
    }

    public void removeRecordsWithType(int type) {
        int remove = -1;
        for (int i = 0; -1 == remove && i < this.recordList.size(); ++i) {
            EXTHRecord rec = this.recordList.get(i);
            if (rec.getRecordTypeAsInt() != type) continue;
            remove = i;
        }
        if (-1 != remove) {
            this.recordList.remove(remove);
            this.recomputeFields();
        }
    }

    public boolean setAllRecordsWithTypeToString(int type, String s, String encoding) {
        boolean changed = false;
        for (EXTHRecord rec : this.recordList) {
            if (rec.getRecordTypeAsInt() != type) continue;
            rec.setRecordDataToString(s, encoding);
            changed = true;
        }
        if (changed) {
            this.recomputeFields();
        }
        return changed;
    }

    public void addRecord(int recType, String s, String encoding) {
        EXTHRecord rec = new EXTHRecord(recType, StreamUtils.stringToByteArray(s, encoding));
        this.recordList.add(rec);
        this.recomputeFields();
    }

    public void addRecord(int recType, byte[] buffer) {
        this.recordList.add(new EXTHRecord(recType, buffer));
        this.recomputeFields();
    }

    protected int dataSize() {
        int size = 0;
        for (EXTHRecord rec : this.recordList) {
            size += rec.size();
        }
        return size;
    }

    protected int paddingSize(int dataSize) {
        int paddingSize = dataSize % 4;
        if (paddingSize != 0) {
            paddingSize = 4 - paddingSize;
        }
        return paddingSize;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.identifier);
        out.write(this.headerLength);
        out.write(this.recordCount);
        for (EXTHRecord rec : this.recordList) {
            rec.write(out);
        }
        int padding = this.paddingSize(this.dataSize());
        for (int i = 0; i < padding; ++i) {
            out.write(0);
        }
    }

    public void dumpHeader() {
        String dump = "EXTHHeader\r\n\tidentifier - " + StreamUtils.dumpByteArray(this.identifier) + " '" + StreamUtils.byteArrayToInt(this.identifier) + "'\r\n\theaderLength - " + StreamUtils.dumpByteArray(this.headerLength) + " '" + StreamUtils.byteArrayToInt(this.headerLength) + "'\r\n\trecordCount - " + StreamUtils.dumpByteArray(this.recordCount) + " '" + StreamUtils.byteArrayToInt(this.recordCount) + "'\r\n";
        if (null != this.recordList) {
            dump = dump + "\tnon-null recordInfoList, with " + this.recordList.size() + " records\r\n";
            for (int i = 0; i < this.recordList.size(); ++i) {
                EXTHRecord er = this.recordList.get(i);
                dump = dump + "\t\texthRecord[" + i + "]\r\n\t\t\trecordType - " + StreamUtils.dumpByteArray(er.getRecordTypeAsByteArray()) + " '" + StreamUtils.byteArrayToInt(er.getRecordTypeAsByteArray()) + "' - ''\r\n\t\t\trecordLength - " + StreamUtils.dumpByteArray(er.getRecordLengthAsByteArray()) + " '" + StreamUtils.byteArrayToInt(er.getRecordLengthAsByteArray()) + "'\r\n\t\t\trecordData - " + StreamUtils.dumpByteArray(er.getRecordDataAsByteArray()) + " '" + StreamUtils.byteArrayToString(er.getRecordDataAsByteArray()) + "'\r\n";
            }
        } else {
            dump = dump + "\tnull recordInfoList";
        }
        System.out.println(dump);
    }
}

