.TH ACCIRC 1 "13 November 2014"
.SH NAME
accirc \- The accidental ncurses irc client
.SH SYNOPSIS
\fBaccirc\fP [ --help | --version ]
.TP
\fBaccirc\fP [ --ignorerc ] [ --proper ]
.SH DESCRIPTION
\fBaccirc\fP starts ncurses; functionality is available from there; config is read from ~/.config/accirc/config.rc ; logs are stored in ~/.local/share/accirc/logs/
.SS Options
.TP
\fB--help\fP
tells you to read this man page
.TP
\fB--version\fP
outputs the version of this software, in the form <major int>.<minor int>; major counts redesigns, minor counts updates; for both, even numbers are stable, odd numbers are unstable/testing; also tells the compile date and time
afterwards immediately closes the program
.TP
\fB--ignorerc\fP
runs the program without running the startup (rc) file located in ~/.config
.TP
\fB--proper\fP
disables "easy mode"; "easy mode" is on by default and adds aliases for /nick, /msg, and /quit, as well as auto-sends user and nick information on a connect command
.SS Commands
.TP
\fB\\\fP
escapes the first character of the input string (in case you want a literal : or /)
.TP
\fB:\fP
sends raw data to the current server (if there is one)
.TP
\fB/help\fP
tells you to read this manual page
.TP
\fB/connect\fP \fIhost\fP \fIport\fP
attempts to connect to an irc server at <host> on port <port>
.TP
\fB/sconnect\fP \fIhost\fP \fIport\fP
attempts to connect to an irc server at <host> on port <port> using ssl (via openssl) (with the the "nossl" make option this command will not exist)
.TP
\fB/exit\fP [ message ]
sends a QUIT to every irc server you're connected to, and exits the program
.TP
\fB/cli_escape\fP \fInew\fP
changes the client command escape character to <new>, if possible
.TP
\fB/ser_escape\fP \fInew\fP
changes the server raw data escape character to <new>, if possible
.TP
\fB/alias\fP \fItrigger\fP \fIsubstitution\fP
registers an alias; when the client escape is used with the trigger the trigger will be substituted for whatever substitution is specified; for example "/alias part :part" would allow you to use /part in place of :part ; note this is a direct text substitution and does no additional handling ; an empty substitution deletes an alias
.TP
\fB/time_format\fP \fInew_format\fP
sets the time format for viewing (the clock and timestamps on messages in ncurses); note that logs always use unix timestamps, and ignore this formatting; for time formatting variables, see man 3 strftime
.TP
\fB/set_version\fP \fInew_version_string\fP
sets the new_version_string as the response to any CTCP VERSION messages received (leave blank to re-set to default value)
.TP
\fB/set_quit_msg\fP \fInew_quit_message\fP
sets the new_quit_message as the quit (and by extension exit) message for current server when no parameters are given (leave blank to re-set to default value)
.TP
\fB/easy_mode\fP
turns easy_mode on (this is the default unless the --proper switch is provided); easy mode automatically sends user and nick information on new connections, and provides noob aliases
.TP
\fB/no_easy_mode\fP
turns easy_mode off
.TP
\fB/reconnect\fP
reconnect to the currently selected server if connection is lost for any reason
.TP
\fB/no_reconnect\fP
don't reconnect to the currently selected server
.TP
\fB/manual_reconnect\fP
attempt to manually reconnect to this server, even if the connection is not detected as dropped
.TP
\fB/log\fP
keep logs for the currently selected server (this is the default)
.TP
\fB/no_log\fP
don't keep logs for the currently selected server
.TP
\fB/rsearch\fP \fIsearch_string\fP
searches up from the current scroll position for the given search_string (exact string search, case sensitive, no globbing or regexes)
.TP
\fB/up\fP
scrolls up one line, if possible
.TP
\fB/down\fP
scrolls down one line, if possible
.TP
\fB/head\fP
scrolls to the top of the scrollback area for the current channel
.TP
\fB/tail\fP
scrolls to the bottom of the scrollback area for the current channel
.TP
\fB/scl\fP
swaps this channel with the channel to its left in the channel list, if possible
.TP
\fB/scr\fP
swaps this channel with the channel to its right in the channel list, if possible
.TP
\fB/hi \fInick\fP
opens a faux-channel PM with the given nick, which keeps seperate logs, etc.
.TP
\fB/bye\fP
parts the currently active faux-PM channel; if the active channel is not a PM, an error message is sent and this does nothing
.TP
\fB/sl\fP
sets active server one left of current server
.TP
\fB/sr\fP
sets active server one right of current server
.TP
\fB/cl\fP
sets active channel one left of current channel
.TP
\fB/cr\fP
sets active channel one right of current channel
.TP
\fB/me\fP
sends CTCP ACTION message
.TP
\fB/r\fP
replies (by privmsg) to the last user we recieved a PM from on the currently selected server; if we have never gotten a PM, the default nick to reply to is the null string ""; parsing in some server implementations may treat this strangely, but it's out of my hands, the client will act as intended and send a "privmsg nick :msg" to the server
.TP
\fB/usleep\fP \fImicroseconds\fP
sleeps a given number of microseconds
.TP
\fB/comment\fP
ignore this line, a comment (for an rc file)
.TP
\fB/fallback_nick\fP \fInick\fP
set this as the backup nick if the nick specified is taken; if this nick is also taken _ is appended until one is unclaimed or we run out of characters allowed in the nick (for an rc file)
.TP
\fB/post \fIserver_command\fP
delays exeuction of subsequent (server) commands for this server until the given server_command is received (used for rc files, for example nickserv ident and channel auto-joining should wait for an 001 message); note that client commands continue to execute as normal, and are not affected, even though server commands are delayed
.TP
\fB/no_post\fP
a user-accessible way to get out of post-listening mode, in case you get stuck there
.TP
\fB/rejoin_on_kick\fP
for channels on current server, rejoin when kicked
.TP
\fB/no_rejoin_on_kick\fP
for channels on current server, don't rejoin when kicked
.TP
\fB/mode_str\fP
for channels on the current server, display mode strings with nicks
.TP
\fB/no_mode_str\fP
for channels on the current server, don't display mode strings with nicks (default)
.TP
\fB/ping_toggle \fIphrase\fP
toggles whether or not the given phrase is considered a PING condition (note this is case-insensitive!)
.SS "Key Bindings"
.TP
\fBf1 or alt+left\fP
channel left (see /cl)
.TP
\fBf2 or alt+right\fP
channel right (see /cr)
.TP
\fBf3 or alt+up\fP
server left (see /sl)
.TP
\fBf4 or alt+down\fP
server right (see /sr)
.TP
\fBf5 or alt+tab\fP
literal tab character, displays as a bold _ in the input and display areas
.TP
\fBf6\fP
0x01 character, since screen intercepts literal ^A (for manually sending CTCP messages other than ACTION); displays as a bold \\ in input area
.TP
\fBf7\fP
0x03 character for sending MIRC colors (MIRC color support is still experimental, and requires compilation with -D MIRC_COLOR); displays as a bold \^ (caret) in input area
.TP
\fB<tab>\fP
complete a nickname based on nicks in current channel
.TP
\fBPgUp\fP
scroll up one line in the channel scrollback, if possible
.TP
\fBPgDn\fP
scroll down one line in the channel scrollback, if possible
.TP
\fBUp\fP
scroll up one line in the input history, if possible
.TP
\fBDown\fP
scroll down one line in the input history, if possible
.SH FILES
.TP
\fC~/.config/accirc/config.rc\fR
The startup file to run
.TP
\fC~/.local/share/accirc/logs/\fR
The location of all logs from all servers
.TP
\fC~/.local/share/accirc/error_log.txt\fR
A log of any errors that couldn't be output through ncurses
.SH "EXAMPLE RC FILE
.TP
\fB~/.config/accirc/config.rc\fR
/comment set aliases and time for common preference, then connect to a server and join a channel

/alias quit /exit

/time_format %Y-%m-%d %R:%S

/comment ssl connection commented out

/comment /sconnect daemonic.foonetic.net 7001

/connect daemonic.foonetic.net 6667

:nick accirc_user

:user 1 2 3 4

/comment some error handling just in case the desired nick is unavailable or connection gets lost, etc.

/fallback_nick accirc_user

/reconnect

/rejoin_on_kick

/comment the post client command replaces the old autoident and autojoin commands (which were in versions including and prior to 0.4)

/comment this breaks backwards compatability but is much more general and flexible

/post 001

:join #faid3.0

:privmsg NickServ :IDENTIFY password

.SH "SEE ALSO"
ncurses(3) strftime(3) openssl(3)
.SH BUGS
MIRC colors don't work under screen. auto-reconnecting on drop is unreliable. On the faux-channel PM handling, the PM conversation will behave weirdly if user's nick changes (it's a TODO in the code).  faux-PM channels are CASE-SENSITIVE, this shouldn't be noticable, but you never know
.SH WWW
http://neutrak.kaycare.co.uk/index.php?p=code
.TP
https://github.com/neutrak/accirc

