#!/bin/sh

DOWNLOADER_DIR=`/usr/bin/dirname $0`;
cd "$DOWNLOADER_DIR"

. ./config.sh

TMP_DIR=/tmp/fictionwise
URL="https://www.fictionwise.com/servlet/mw"
POST_DATA="action=login&continue=&loginid=$USERNAME&password=$PASSWORD"
POST_DOWNLOAD="action=downloadzip&type=undownloaded&format=$FORMAT"
# POST_DOWNLOAD="action=downloadzip&type=date&startmonth=4&startdate=1&startyear=2008&format=mo.prc"

if [ -e /usr/bin/curl ]; then
	CURL=curl
else
	CURL=./curl.bin
fi

if [ `$CURL -k -s -c cookies.txt -d "$POST_DATA" "$URL" | grep loginfailure | wc -l` -eq 1 ]; then
	echo 'Login failed!';
	exit 1;
fi

echo "Login ok, looking for new downloads."

CONTENT_TYPE="`$CURL -k -s -o /tmp/books.zip -L -w '%{content_type}' -d "$POST_DOWNLOAD" -b cookies.txt "$URL"`"

if [ "$CONTENT_TYPE" = "application/x-zip-compressed" ]; then
	echo "Found new books...";
	mkdir -p "$TARGET_DIR";
	mkdir -p "$TMP_DIR"
	# Todo: Create manifest.xml etc. according to csv file
	unzip -n /tmp/books.zip -d "$TMP_DIR";
	rm $TMP_DIR/*.csv;
	rm $TMP_DIR/readme_*.txt;
	cd $TMP_DIR
	for file in *; do ln -s "$TARGET_DIR/$file" "/mnt/settings/downloadhistory/$file"; done;
	cd $SCRIPT_DIR
	mv $TMP_DIR/* "$TARGET_DIR";
	rm -r "$TMP_DIR";
else
	echo "No new books found.";
fi;
