#!/usr/bin/env python
#-*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
import sys
import re

def run(bk):
	lastid = 0
	fnid = 0
# all xhtml/html files - moves found notes to end of file, insert a link in the text and link to css in the files with notes
	for (id, href) in bk.text_iter():
		html = bk.readfile(id)
		html_original = html
		found = re.search(r'\^\[.*\]',html)
		if found is not None: #only once for each file with notes
			html = re.sub(r'\<\/head\>',r'<link href="../Styles/footnote.css" rel="stylesheet" type="text/css"/>\n</head>',html)
		while found is not None: #once for every found note. If necessary, replace the words "Note" and "Back" with whatever you see fit
			fnid = fnid+1
			html = re.sub(r'\^\[(.*)\]',r'<a class="footnoteRef" href="#fn'+str(fnid)+'" id="fnref'+str(fnid)+'">Note '+str(fnid)+')</a>',html,1)
			html = re.sub(r'\<\/body\>',r'\n\n<div class="footnote" id="fn'+str(fnid)+'">\n<p class="fn">'+found.group(0).strip('[]^')+'</p>\n<p class="fnrightalign"><a href="#fnref'+str(fnid)+'">Back</a></p>\n</div>\n</body>',html,1)
			print(id, href, 'Note '+str(fnid)+':' + found.group(0).strip('[]^'))
			found = re.search(r'\^\[.*\]',html)
		else:
			print(id, href, "No notes found")
		if not html == html_original:
			bk.writefile(id,html)
		lastid = id
#css
	if fnid > 0:
		cssdata = '.footnote {\n   font-size: 0.95em;\n   margin-left: 1em;\n   margin-top: 1em;\n   padding-top: 1em;\n   text-indent: 0;\n   text-align: justify;\n   page-break-before: always;\n   border-top: 1px;\n   border-bottom: 0;\n   border-left: 0;\n   border-right: 0;\n   border-style: solid;\n   border-color: black;\n   padding-top: 1em;\n   width: 75%;\n   }'
		cssdata = cssdata + '\n.fn {\n   text-indent: 0;\n   }'
		cssdata = cssdata + '\na.footnoteRef {\n   text-decoration: none;\n   border-bottom: 1px dotted;\n   color: inherit;\n   position: relative;\n   top: -0.5em;\n   font-size: 70%;\n   }'
		cssdata = cssdata + '\n.fnrightalign {\n   text-align: right;\n   margin-right: 10%;\n   text-decoration: none;\n   color: inherit;\n   font-style: oblique;\n   }'
		basename = "footnote.css"
		uid = "footnotecss"
		mime = "text/css"
		bk.addfile(uid, basename, cssdata, mime)
	return 0

def main():
	print("I reached main when I should not have\n")
	return -1

if __name__ == "__main__":
	sys.exit(main())