#!/bin/sh
# original script by frostschutz (version: KoboRoot-AutoShelf-3.16.10.zip), cf. http://www.mobileread.com/forums/showthread.php?t=254554
# adapted for KSM by tshering

ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}
targetmd5sum=$ksmroot/log/autoshelf_md5sum
sqlite3prg=$ksmroot/tools/sqlite3


autoshelf() {
    echo "PRAGMA synchronous = OFF;"
    echo "PRAGMA journal_mode = MEMORY;"
    echo "BEGIN TRANSACTION;"

    echo "DELETE FROM Shelf WHERE InternalName LIKE '%/';"
    echo "DELETE FROM ShelfContent WHERE ShelfName LIKE '%/';"

    local i=0

    if [ -e /mnt/onboard/.autoshelf-uninstall ]
    then
        echo "DELETE FROM Activity WHERE Type='Shelf' AND Id LIKE '%/';"
        echo "END TRANSACTION;"
        return
    fi

    $sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite "
    SELECT ContentID FROM content
    WHERE ContentType = 6
      AND ContentID LIKE 'file:///mnt/%'
    ORDER BY ContentID
    ;" | while read file
    do
        i=$(($i+1))
        date="strftime('%Y-%m-%dT%H:%M:%SZ','now','-$i minute')"
        file=$(echo "$file" | sed -e "s@'@''@g")
        shelf=$(dirname "$file" | sed -r -e 's@^file://*mnt//*(onboard|sd)/*@@')
        word=$(basename "$file")
        for number in $word; do break; done

        if [ "$shelf" == "" ]
        then
            series="$word"
        else
            series="$shelf"
        fi

        if [ "$shelf" != "$prevshelf" ]
        then
            prevshelf="$shelf"
            echo "REPLACE INTO Shelf VALUES($date,'$shelf/','$shelf/',$date,'$shelf/',NULL,'false','true','false');"
        fi

        echo "INSERT INTO ShelfContent VALUES('$shelf/','$file',$date,'false','false');"

        echo "
        UPDATE content
        SET Series='$series', SeriesNumber='$number'
        WHERE ContentID='$file'
        ;"
    done

    echo "END TRANSACTION;"
}


if [ -e /mnt/onboard/.kobo/KoboReader.sqlite ]
then
#    /etc/init.d/update-animator.sh &
    result=$(autoshelf)

    if echo "$result" | md5sum -c $targetmd5sum > /dev/null 2>&1
    then
        echo "Already done..."
    else
        echo "$result" | md5sum > $targetmd5sum
        echo "$result" | $sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite  > /dev/null 2>&1
         echo "Database updated..."
    fi
#    killall update-animator.sh
fi


