#!/bin/bash -e

# Needs an x-compile env setup (don't forget to export KINDLE_TC first)...
echo "* Launching ${KINDLE_TC} build . . ."
# This also needs to be up to date...
LIBPNG_SOVER="16.18.0"
ZLIB_SOVER="1.2.8"

# link against zlib & libpng statically
echo "* Static link trickery . . ."
for my_lib in libpng16.so libpng16.so.16 libpng16.so.${LIBPNG_SOVER} libz.so libz.so.1 libz.so.${ZLIB_SOVER} ; do
	mv -v ${TC_BUILD_DIR}/lib/{${my_lib},_${my_lib}}
done

mkdir -p ${KINDLE_TC}
make clean
make CC=${CROSS_TC}-gcc
${CROSS_TC}-strip --strip-unneeded fbgrab
cp -av fbgrab ${KINDLE_TC}/fbgrab
make clean

echo "* Undo static link trickery :)"
for my_lib in libpng16.so libpng16.so.16 libpng16.so.${LIBPNG_SOVER} libz.so libz.so.1 libz.so.${ZLIB_SOVER} ; do
	mv -v ${TC_BUILD_DIR}/lib/{_${my_lib},${my_lib}}
done
