#!/bin/sh
ksmroot=${ksmroot:-"/adds/kbmenu"}
frontlightprg=$ksmroot/tools/frontlight
dontTamperwithFrontlight=${dontTamperwithFrontlight:-"true"}


if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
  $ksmroot/kbmessage.sh "Please handle your update files!"
  exit
fi

kbmenuonstartdir=$ksmroot/onstart

tempdir=/tmp/kbmenu
nkloopfifo=$tempdir/nkloopfifo
mkdir -p $tempdir
mkfifo $nkloopfifo
currentRotation=$(cat /sys/class/graphics/fb0/rotate)
while :
do
  if [ -p "$nkloopfifo" ]; then
    $kbmenuonstartdir/start_koreader.sh
  else
#set frontlight for KSM
    [ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ] && (
    $frontlightprg "$KSMfrontlightlevel"
    )
    exit
  fi
  $kbmenuonstartdir/start_nickel_fromloop.sh
  echo "$currentRotation" > /sys/class/graphics/fb0/rotate
  cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate
done
