#!/bin/sh
#
# Misc hack checker...
#
# $Id: install.sh 10674 2014-06-26 21:21:25Z NiLuJe $
#
##

# Pull libOTAUtils for logging & progress handling
[ -f ./libotautils5 ] && source ./libotautils5


## Here we go :)
otautils_update_progressbar

HACKLOG="/mnt/us/dummy_testupdate.log"

# The goal here is to check that we're really in a vanilla state, to verify that our custom hacks properly stopped
echo "** Dummy Test Install **" > ${HACKLOG}

# We start by checking the process list...
echo "** Process list:" >> ${HACKLOG}
ps faux >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Then the mtab
echo "** MTab:" >> ${HACKLOG}
cat /etc/mtab >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# And df -h
echo "** Mounted Partitions:" >> ${HACKLOG}
df -h >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The update package private keys
echo "** Checking private keys..." >> ${HACKLOG}
echo "" >> ${HACKLOG}
for keyfile in /etc/uks/*.pem ; do
	echo "** ${keyfile} **" >> ${HACKLOG}
	cat ${keyfile} >> ${HACKLOG} 2>&1
	echo "" >> ${HACKLOG}
done
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Then the userstore
echo "** UserStore:" >> ${HACKLOG}
ls -lash /mnt/us >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Checking USBNetwork
echo "** USBNetwork..." >> ${HACKLOG}
echo "" >> ${HACKLOG}
echo "** /usr/local content **" >> ${HACKLOG}
ls -lash /usr/local >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}
echo "** /usr/local/sbin content **" >> ${HACKLOG}
ls -lash /usr/local/sbin >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}
echo "** /usr/local/bin content **" >> ${HACKLOG}
ls -lash /usr/local/bin >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}
echo "** /usr/local/etc/dropbear content **" >> ${HACKLOG}
ls -lash /usr/local/etc/dropbear >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}
echo "** /usr/local/bin/usbnetwork.sh content **" >> ${HACKLOG}
cat /usr/local/bin/usbnetwork.sh >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Then the ss hack state files...
echo "** SS Hack state files:" >> ${HACKLOG}
ls -lash /mnt/us/linkss >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the original directory...
echo "** SS Hack original screensavers check:" >> ${HACKLOG}
ls -lash /usr/share/blanket/screensaver >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the custom directory...
echo "** SS Hack custom screensavers check:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/screensavers >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the overflow directory...
echo "** SS Hack overflow screensavers check:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/overflow >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the discarded directory...
echo "** SS Hack discarded screensavers check:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/discarded >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the cover_cache directory...
echo "** SS Hack cover_cache screensavers check:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/cover_cache >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the current cover directory...
echo "** SS Hack current cover (tmpfs):" >> ${HACKLOG}
ls -lash /var/linkss/cover >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Check the current cache directory...
echo "** SS Hack current cover cache (tmpfs):" >> ${HACKLOG}
ls -lash /var/linkss/cache >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The ss hack pidfiles...
echo "** SS Hack pidfiles:" >> ${HACKLOG}
ls -lash /mnt/us/linkss/run >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# In detail, if there's one...
if [ -f /mnt/us/linkss/run/usb-watchdog.pid ] ; then
    echo "** SS Hack pidfiles (usb-watchdog.pid):" >> ${HACKLOG}
    cat /mnt/us/linkss/run/usb-watchdog.pid >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

otautils_update_progressbar

# In detail, if there's one...
if [ -f /mnt/us/linkss/run/cover-watchdog.pid ] ; then
    echo "** SS Hack pidfiles (cover-watchdog.pid):" >> ${HACKLOG}
    cat /mnt/us/linkss/run/cover-watchdog.pid >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

otautils_update_progressbar

# The ss hack custom_screensavers dir...
echo "** SS Hack custom_screensavers (in varlocal):" >> ${HACKLOG}
ls -lash /var/local/custom_screensavers >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Then the font hack state files...
echo "** Font Hack state files:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The ss hack pidfiles...
echo "** Font Hack pidfiles:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/run >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# In detail, if there's one...
if [ -f /mnt/us/linkfonts/run/usb-watchdog.pid ] ; then
    echo "** Font Hack pidfiles (usb-watchdog.pid):" >> ${HACKLOG}
    cat /mnt/us/linkfonts/run/usb-watchdog.pid >> ${HACKLOG} 2>&1
    echo "" >> ${HACKLOG}
fi

otautils_update_progressbar

# The font hack fonts...
echo "** Font Hack fonts:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/fonts >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The font hack FC configs...
echo "** Font Hack FC configs:" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/etc/conf.d >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The font hack cache (in us)...
echo "** Font Hack cache (userstore):" >> ${HACKLOG}
ls -lash /mnt/us/linkfonts/cache >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The font hack cache (in tmpfs)...
echo "** Font Hack cache (tmpfs):" >> ${HACKLOG}
ls -lash /var/cache/fontconfig >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The font hack cache (in tmpfs)...
echo "** Font Hack libs (tmpfs):" >> ${HACKLOG}
ls -lash /var/local/linkfonts/lib >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# The varlocal pidfiles...
echo "** varlocal pidfiles:" >> ${HACKLOG}
ls -lash /var/local/run >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

otautils_update_progressbar

# Done!
echo "Done!" >> ${HACKLOG}

otautils_update_progressbar

return 0
