#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Build a simple Kindle update to install custom fonts
#
# $Id: build-update.py 6913 2010-09-30 21:11:26Z NiLuJe $
#
##

import tarfile, gzip
import sys, os

# Config
hackname = "font_pkg"
pkgver = "1.0.N"
hackpkg = "%s.tar.gz" %( hackname )

# 'Borrowed' from the packager ;)
def add_tarfile( tarinfo, file, tar, mode=0100644 ):
	tarinfo.mode = mode
	tarinfo.uid = tarinfo.gid = 0
	tarinfo.uname = tarinfo.gname = "root"
	fs = open( file, 'rb' )
	tar.addfile( tarinfo, fs )
	fs.close( )

# Dear Windows, please die in a fire.
if sys.platform == "win32":
	kpacker = "kindle_update_tool.py"
	os.putenv( "PATH", '%PATH%;C:\OpenSSL-Win32\\bin;C:\OpenSSL\\bin' )
else:
	kpacker = "python ./kindle_update_tool.py"

# Take a path with the fonts to package as an arg
if len( sys.argv ) <= 1:
	# Default to PWD
	fontpath = "."
else:
	fontpath = sys.argv[1]
	# Sanity check
	if os.path.isdir( fontpath ):
		print "* Packaging fonts in %s . . ." %( fontpath )
	else:
		print "! %s is not a valid directory, aborting!" %( fontpath )
		sys.exit( 1 )

# Build a tgz with our custom fonts
tar = tarfile.open( hackpkg, "w:gz" )

# Base fonts (needed)
for font_type in [ "Serif", "Sans", "Mono" ]:
	for font_style in [ "Regular", "Bold", "Italic", "BoldItalic" ]:
		font_file = os.path.join( fontpath, "%s_%s.ttf" ) %( font_type, font_style )
		if os.path.isfile( font_file ):
			print "* Adding font %s . . ." %( os.path.basename( font_file ) )
			tarinfo = tar.gettarinfo( font_file, arcname=os.path.basename( font_file ) )
			add_tarfile( tarinfo, font_file, tar )
		else:
			print "! Font %s is missing! Aborting." %( os.path.basename( font_file ) )
			sys.exit( 1 )

# I18N fonts (optional)
for font in [ "CJK", "I18N" ]:
	font_file = os.path.join( fontpath, "%s.ttf" ) %( font )
	if os.path.isfile( font_file ):
		print "* Adding font %s . . ." %( os.path.basename( font_file ) )
		tarinfo = tar.gettarinfo( font_file, arcname=os.path.basename( font_file ) )
		add_tarfile( tarinfo, font_file, tar )
	else:
		print "! Font %s is missing! Aborting." %( os.path.basename( font_file ) )

# Close our tape archive
tar.close( )

# Package it for Kindle 3
kindle_models = [ "k3g", "k3w", "k3gb" ]

for model in kindle_models:
	arch = "%s_%s_%s" %( hackname, pkgver, model )

	# Build install update
	os.system( "%s m --%s --sign %s install.sh %s" %( kpacker, model, arch, hackpkg ) )

	# Move the binfile
	binfile = "update_%s.bin" %( arch )
	os.rename( binfile, os.path.join( "..", binfile ) )

# Remove our tgz
os.remove( hackpkg )
