#!/bin/sh
# Note: do not intend "EOF"


ksmroot=${ksmroot:-"/mnt/onboard/.adds/kbmenu"}

sqliteprog=$ksmroot/tools/sqlite3
database=/mnt/onboard/.kobo/KoboReader.sqlite
dictionary="$1"

if [ ! -f "$database" ]; then
  echo "Error:_Cannot_find_database"
  exit;
fi

dict_size=$(stat -c%s $dictionary)
dict_lastmodified=$(stat -c%y $dictionary)
dict_lastmodified=${dict_lastmodified%%.*}
dict_day=${dict_lastmodified%% *}
dict_time=${dict_lastmodified#*" "}
dict_lastmodified=$(echo $dict_day"T"$dict_time)

dictionary=$(basename $dictionary)
if [ "$dictionary" == "dicthtml.zip" ]; then
  dict_suffix="en"
else
  dict_suffix=${dictionary/"dicthtml-"/}
  dict_suffix=${dict_suffix/".zip"/}
fi

case $dict_suffix in
  de* )
    firstlanguage=Deutsch
    ;;
  en* )
    firstlanguage=English
    ;;
  es* )
    firstlanguage=Español
    ;;
  fr* )
    firstlanguage=Français
    ;;
  it* )
    firstlanguage=Italiano
    ;;
  ja* )
    firstlanguage="日本語"
    ;;
  nl* )
    firstlanguage=Nederlands
    ;;
  pt* )
    firstlanguage=Português
    ;;
  * )
    echo "unsupported_language"
    exit
    ;;
esac

secondlanguage=
case $dict_suffix in
  ??-de )
    secondlanguage=Deutsch
    ;;
  ??-en )
    secondlanguage=English
    ;;
  ??-es )
    secondlanguage=Español
    ;;
  ??-fr )
    secondlanguage=Français
    ;;
  ??-it )
    secondlanguage=Italiano
    ;;
  ??-ja )
    secondlanguage="日本語"
    ;;
  ??-nl )
    secondlanguage=Nederlands
    ;;
  ??-pt )
    secondlanguage=Português
    ;;
  *-* )
      echo "unsupported_second_language"
      exit
    ;;
esac

dict_lang=$firstlanguage
[ "x$secondlanguage" != "x" ] && dict_lang="$dict_lang - $secondlanguage"
dict_suffix="-$dict_suffix"

$sqliteprog $database <<EOF
replace into "Dictionary" VALUES ('$dict_suffix', '$dict_lang', 'true', '$dict_size', '$dict_lastmodified', 'true');
EOF

echo "sqlite exit code: $?"


