#!/bin/sh

ksmroot=${ksmroot:-"/mnt/onboard/.adds/kbmenu"}

if [ "$KSMdebugmode" == "true" ]; then
#debug_logfile=/mnt/onboard/ksmdebug_$(date +%Y%m%d_%H%M%S)_kbconfsel.sh.log
  debug_logfile=/mnt/onboard/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "product: $PRODUCT" >> $debug_logfile
  echo "ksmGeometryValuesN: $ksmGeometryValuesN"  >> $debug_logfile
  echo "ksmGeometryValuesE: $ksmGeometryValuesE"  >> $debug_logfile
  echo "ksmGeometryValuesS: $ksmGeometryValuesS"  >> $debug_logfile
  echo "ksmGeometryValuesW: $ksmGeometryValuesW"  >> $debug_logfile
  echo "arguments: $@"  >> $debug_logfile
sync
fi


export QT_PLUGIN_PATH=$ksmroot/Qt/plugins
export LD_LIBRARY_PATH=$ksmroot/Qt/lib
export QWS_MOUSE_PROTO=KoboTS
export QT_QWS_FONTDIR=$ksmroot/Qt/fonts
#export QWS_KEYBOARD=KoboKb


if [ "$mrotation" == "0" ] || [ "$mrotation" == "90" ] || [ "$mrotation" == "180" ] || [ "$mrotation" == "270" ]; then
  export QWS_DISPLAY=Transformed:KoboFB:Rot$mrotation
else
  export QWS_DISPLAY=Transformed:KoboFB:Rot90
fi


if [ "$mrotation" == "0" ] && [ "x$ksmGeometryValuesE" != "x" ]; then
  answer=$($ksmroot/kbconfsel "$@" -qws -geometry $ksmGeometryValuesE)
elif [ "$mrotation" == "90" ] && [ "x$ksmGeometryValuesN" != "x" ]; then
  answer=$($ksmroot/kbconfsel "$@" -qws -geometry $ksmGeometryValuesN)
elif [ "$mrotation" == "180" ] && [ "x$ksmGeometryValuesW" != "x" ]; then
  answer=$($ksmroot/kbconfsel "$@" -qws -geometry $ksmGeometryValuesW)
elif [ "$mrotation" == "270" ] && [ "x$ksmGeometryValuesS" != "x" ]; then
  answer=$($ksmroot/kbconfsel "$@" -qws -geometry $ksmGeometryValuesS)
else
  answer=$($ksmroot/kbconfsel "$@" -qws)
fi

[ "$KSMdebugmode" == "true" ] && echo "answer: $answer" >> $debug_logfile
echo "$answer"
