#!/bin/sh
# Note: do not intend "EOF"

database=/mnt/onboard/.kobo/KoboReader.sqlite


ksmroot=${ksmroot:-"/mnt/onboard/.adds/kbmenu"}


sqliteprog=$ksmroot/tools/sqlite3

if [ ! -f "$database" ]; then
  echo "Error:_Cannot_find_database"
  exit;
fi

usercount=$($sqliteprog $database 'SELECT COUNT(*) FROM user')
error=$?

case $error in
  0 )
    if [ "$usercount" -eq 1 ]; then
      $sqliteprog $database <<EOF
      CREATE TEMPORARY TABLE user2 AS SELECT * FROM user Limit 1;
      UPDATE user2 SET UserID="foo";
      INSERT INTO user SELECT * FROM user2;
      DROP TABLE user2;
EOF
      message="The_device_is_now_activated."
    else
      message="The_device_was_already_activated."
    fi
    ;;
  *)
    message="There_occured_an_error_the_exit code_was:$error"
    ;;
esac;

echo "$message"
