// fbswitch.c
//
// Strem new framebuffer in on stdin,
// Stream old framebuffer out on stdout,
// Include framebuffer configuration data when streaming framebuffer,
// so it may be restored identically.
// FIXME, maybe: IO restarting due to signal interruptions is not handled.h
//
// Examples of usage:
// echo -n | fbswitch | gzip - -c > /tmp/fb1.gz # only saves fb, no load.
// eg: zcat /tmp/fb0.gz | fbswitch | gzip - -c > /tmp/fb1.gz # save and load.

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/fb.h>
#include "mxcfb.h"

int main(int narg,char** arg) {
	int fbfd=open("/dev/fb0",O_RDWR);
	struct fb_var_screeninfo vinfo;
	struct mxcfb_update_data region;
	char* buffer[1024];
	int n;
	int rotate;

	if (fbfd<0) return errno;
	errno=0;

	// First, backup the old framebuffer	
	ioctl(fbfd, FBIOGET_VSCREENINFO, &vinfo );
	if (errno) return errno;

	write( STDOUT_FILENO, (void*)&vinfo, sizeof(vinfo) ); // Save fb configure 
	while( (n=read(fbfd, buffer, 1024))>0 ) write(1, buffer, n);
	if (n<0) return errno;
	close(1);

	close(fbfd);
	fbfd = open("/dev/fb0",O_RDWR );

	// Next, load the framebuffer from stdin (if available).
	n=read( STDIN_FILENO, (void*)&vinfo, sizeof(vinfo));
	if (n && (n!=sizeof(vinfo))) return 1; // Corrupted configuration.. error. 
	if (n!=sizeof(vinfo)) return 0; // No data at all, so nothing to load.

	// Set the framebuffer mode, for the new picture.
	// There is a bug in the AuraHD, so to get it to operate correctly in
	// all modes, first we write the orientation flipped -- and then
	// we write it a second time, reversing whatever value the reader
	// puts into the rotation slot.  This appears to fix the bug,
	// while allowing correctly working readers to also get the same result.
	
	vinfo.rotate^=2; // write flipped rotation first.
	ioctl(fbfd, FBIOPUT_VSCREENINFO, &vinfo );
	vinfo.rotate^=2; // re-write as un-flipped.
	ioctl(fbfd, FBIOPUT_VSCREENINFO, &vinfo );
	if (errno) return errno;

	// Load the picture into the framebuffer.	
	while( (n=read(STDIN_FILENO,buffer,1024))>0 ) write( fbfd, buffer, n );
	if (n<0) return errno;

	// Refresh the screen with the new framebuffer.
	region.update_marker=0;
	region.update_region.top=0;
	region.update_region.left=0;
	region.update_region.width=vinfo.xres;
	region.update_region.height=vinfo.yres;	
	region.waveform_mode = WAVEFORM_MODE_AUTO;
	region.update_mode = UPDATE_MODE_FULL;
	region.temp = TEMP_USE_AMBIENT;
	region.flags=0;	
	ioctl( fbfd, MXCFB_SEND_UPDATE, &region );
	if (errno) return errno;
	ioctl( fbfd, MXCFB_WAIT_FOR_UPDATE_COMPLETE, &region.update_marker );
	return errno;
}
