#!/bin/bash

# This script tries to show the loss of certain attributes for hierarchal styles when converting from ODT to EPUB via Calibre.

# Versions used:
# Ubuntu 14.04 LTS
# LibreOffice 4.2.8.2
# Calibre 2.32.1

# The doc file has among others, 3 custom styles: roman.description, roman.dialogue and roman.discussion, in that hierachical order.
# Font-size 13pt, justified for roman.description; plus list style InciseDialog for roman.dialogue; plus italic for roman.discussion.

# When converting with ebook-convert, the result in the directory input is already wrong:
# - P-roman_description is OK
# - P-roman_dialogue has no "text-align: justify;" attribute
# - P-roman_discussion is not in odfpy.css file, and the complementary c_odtN has a font-size of 12pt and no justification.

# Files provided:
# Test_d.odt: source
# Test.odt.epub: the final result
# Test_d.pdf: what should be rendered also by the xhtml
# show_bug_cal.sh: this file (just run it in its own directory, if necessery will create empty ./dlg and ./cal).

# Some useful variables
make_epub_version="V1.16"
dlg_par_style=P2
make_epub_ts=`ls -l $0 | cut -d " " -f 6-7 | sed -e "s/-//g" -e "s/ /-/"`
make_epub_version="${make_epub_version}-${make_epub_ts}"
book_short_name=Test
book_version=6.8
publisher="Plumitive Editions"
authors="Nicole Giroud"
cover_credit=""
case ${book_short_name} in
   "Test") :
      book_title="Test dialogs"
      isbn_paper="979-10-93327-00-6"
      isbn_epub="979-10-93327-01-3"
      isbn_mobi="979-10-93327-02-0"
      pubdate=2014-04-03
      ;;
esac
author_lastname=` echo $authors | cut -f 2 -d" "`
author_firstname=` echo $authors | cut -f 1 -d" "`
author_sort="${author_lastname}, ${author_firstname}"
ean=`echo $edited_isbn | tr -d "-" `
isbn=$ean
copyright_year=`echo $pubdate | cut -f 1 -d "-"`

wdir=`pwd`

# Create the 2 working directories
if [ ! -d dlg ]; then
   mkdir -v dlg
fi

if [ ! -d cal ]; then
   mkdir -v cal
fi

### In dlg folder, prepares an EPUB format
   cd dlg
   pwd
   isbn=`echo $isbn_epub | tr -d "-" `
   ebook-convert ../${book_short_name}_d.odt ../${book_short_name}.odt.epub --output-profile generic_eink \
    --publisher "$publisher" --book-producer "$publisher ($make_epub_version)" --language fr --pubdate ${pubdate} --authors "${authors}" --author-sort "${author_sort}" \
    --title "${book_title}" --title-sort "${book_title}" --isbn "${isbn}" \
    --comments "${book_version}" \
    --cover "../Couv_1ere.jpg" --preserve-cover-aspect-ratio \
    --epub-inline-toc --toc-title "Sommaire" --use-auto-toc --level1-toc "//h:h1" \
    --debug-pipeline -vvvvv -d ../cal
    
    echo "*******************"
    echo " From ODT to /input, the attributes are not conserved"
    echo "*******************"
    echo " Showing loss of style P-roman_discussion"
    echo "roman_discussion used..."
    grep discussion ../cal/input/index.xhtml >cal_attr.txt
    cal_attr=`cut -d " " -f 3 cal_attr.txt | cut -d \" -f 1`
    more cal_attr.txt
    echo $cal_attr
    echo "   ... but definition lost: grep discussion on odfpy.css is empty"
    grep discussion ../cal/input/odfpy.css
    echo "   ... and font-size is 12pt and no justification on $cal_attr"
    grep $cal_attr ../cal/input/odfpy.css
    echo ""
    echo "----------------------"
    echo "roman_dialogue used..."
    grep dialogue ../cal/input/index.xhtml    
    echo "   ... but definition has no justification inheritance: text-align:justify is not in roman_dialogue"
    grep dialogue ../cal/input/odfpy.css

    cd $wdir
exit
