@echo off
cls
echo.
echo *********************************
echo *           Pack ROM            *
echo *********************************
echo.

echo *********************************
echo *    Choice chip type:          *
echo *        1. RK28                *
echo *        2. RK281x              *
echo *        3. RK29                *
echo *        4. RK292x              *
echo *        5. RK30                *
echo *        6. RK302A              *
echo *        7. RK31                *
echo *        8. RK32                *

echo *********************************
set /p c=Please, choice chip:
echo.

if %c%==8 GOTO RK_32
IF %c%==7 GOTO RK_31
if %c%==6 GOTO RK_302A
IF %c%==5 GOTO RK_30
IF %c%==4 GOTO RK_292x
IF %c%==3 GOTO RK_29
IF %c%==2 GOTO RK_281x
IF %c%==1 GOTO RK_28

:RK_28
set _chip=RK28 & goto var
:RK_281x
set _chip=RK281x & goto var
:RK_29
set _chip=RK29 & goto var
:RK_292x
set _chip=RK292x & goto var
:RK_30
set _chip=RK30 & goto var
:RK_302A
set _chip=RK302A & goto var
:RK_31
set _chip=RK31 & goto var
:RK_32
set _chip=RK32

:VAR
echo *********************************
echo *    Choice source packing      *
echo *       for chip %_chip%          *
echo *      1. Unpack dir            *
echo *      2. Pack dir              *
echo *      3. Return                *
echo *********************************
set /p var=Please, choice variant:
echo.
if %var%==3 GOTO ret
if %var%==2 set p=Pack& goto NEW_PACK
if %var%==1 set p=Unpack& goto no_cop

:NEW_PACK
echo *     Copy old option?  y/n     *
set /p op=Please, choice Command:
echo.
if %op%==y goto cop
if %op%==n goto no_cop

:cop
echo *      Copy option...           *
copy Unpack\Firmware\parameter Pack\Firmware\ > NUL
copy Unpack\Firmware\recover-script Pack\Firmware\ > NUL
copy Unpack\Firmware\update-script Pack\Firmware\ > NUL
copy Unpack\Firmware\*.bin Pack\Firmware\*.bin > NUL
copy Unpack\Firmware\package-file Pack\Firmware\ > NUL
copy Unpack\Firmware\Image\misc.img Pack\Firmware\Image\misc.img > NUL

:no_cop
echo *      Pack Firmware...         *
Afptool -pack %p%/Firmware/ %p%/update_.img > NUL
echo *      Pack ROM...              *
RKImageMaker.exe -%_chip% %p%/Firmware/boot.bin %p%/update_.img Pack/update_out.img -os_type:androidos > NUL
del %p%\update_.img > NUL

call App/_ok_err.bat Pack\update_out.img
:ret
