@echo off
cls
echo.
echo *********************************
echo *       Pack System (ext4)      *
echo *********************************
echo.

echo *********************************
echo *    Choice source image:       *
echo *      1. Unpack dir            *
echo *      2. Pack dir              *
echo *      3. Return                *
echo *********************************
set /p var=Please, choice source:
echo.
if %var%==3 goto exit
if %var%==2 set p=Pack& goto NEW_PACK
if %var%==1 set p=Unpack& goto NEW_PACK

:NEW_PACK
echo *        Please wait...         *
echo.
(for /f  %%a IN ('du -sk %p%\System') DO set num_blocks=%%a) > NUL 2>&1
set /A num_blocks = %num_blocks%+20480> NUL 2>&1
                                 
:: make ext2 image
echo *        Make image...          *
genext2fs -a -d %p%/system -b %num_blocks% -m 0 Pack/Firmware/Image/system.img > NUL 2>&1
:: convert ext2 to ext3
tune2fs -j -L system -c -1 -i 0 Pack/Firmware/Image/system.img > NUL 2>&1
:: convert ext3 to ext4
tune2fs -O extents,uninit_bg,dir_index Pack/Firmware/Image/system.img > NUL 2>&1
tune2fs -l Pack/Firmware/Image/system.img > Pack/Firmware/Image/system.info 2>&1
echo *        Check image...         *
e2fsck -fy Pack/Firmware/Image/system.img > NUL 2>&1 > NUL 2>&1

:: resize image
(for /f "tokens=2 delims=:"  %%a IN ('resize2fs -P Pack/Firmware/Image/system.img') DO set num_blocks=%%a) > NUL 2>&1
                                                     
del Pack\Firmware\Image\system.img /Q > NUL

echo *        Resize image...        *
:: start to again
genext2fs -a -d %p%/system -b %num_blocks% -m 0 Pack/Firmware/Image/system.img > NUL 2>&1
tune2fs -j -L system -c -1 -i 0 Pack/Firmware/Image/system.img > NUL 2>&1
tune2fs -O extents,uninit_bg,dir_index Pack/Firmware/Image/system.img > NUL 2>&1
tune2fs -l Pack/Firmware/Image/system.img > Pack/Firmware/Image/system.info 2>&1
e2fsck -fyD Pack/Firmware/Image/system.img > NUL 2>&1

:exit
call App/_ok_err.bat Pack/Firmware/Image/system.img
:ret