/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrox.kpvbooklet;

import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcPropertyAdapter;
import com.amazon.kindle.util.lipc.LipcPropertyProvider;
import com.amazon.kindle.util.lipc.LipcService;
import com.amazon.kindle.util.lipc.LipcSource;
import com.github.chrox.kpvbooklet.DictDialog;
import com.github.chrox.kpvbooklet.dictadapter.DictAdapter;
import com.github.chrox.kpvbooklet.util.Log;
import java.io.PrintStream;

class DictBackend {
    private static final String dictsource = "com.github.koreader.kpvbooklet.dict";
    private static final String wordsource = "com.github.koreader.kpvbooklet.word";
    private static final PrintStream logger = Log.INSTANCE;

    DictBackend() {
    }

    public static void addDictBackend() {
        try {
            LipcSource source = LipcService.getInstance().createSource(dictsource);
            DictProperties dictproperty = new DictProperties();
            source.exportStringProperty("lookup", (LipcPropertyProvider)dictproperty, 2);
            source.exportStringProperty("show", (LipcPropertyProvider)dictproperty, 2);
        }
        catch (LipcException e) {
            logger.println("E: " + e.toString());
            e.printStackTrace(logger);
        }
    }

    private static class DictProperties
    extends LipcPropertyAdapter {
        private LipcSource wordSource = null;
        private DictAdapter dictionary = DictAdapter.INSTANCE;

        public DictProperties() throws LipcException {
            this.wordSource = LipcService.getInstance().createSource(DictBackend.wordsource);
        }

        public void setProperty(String property, String word) throws LipcException {
            if (property.equals("lookup") && this.wordSource != null) {
                WordProperties wordproperty = new WordProperties();
                this.wordSource.exportStringProperty(word, (LipcPropertyProvider)wordproperty, 1);
            }
            if (property.equals("show")) {
                DictDialog.post("test", this.dictionary.getDictView(word));
            }
        }
    }

    private static class WordProperties
    extends LipcPropertyAdapter {
        private DictAdapter dictionary = DictAdapter.INSTANCE;

        private WordProperties() {
        }

        public String getStringProperty(String word) throws LipcException {
            return this.dictionary.query(word);
        }
    }
}

