/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrox.kpvbooklet;

import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcPropertyAdapter;
import com.amazon.kindle.util.lipc.LipcPropertyProvider;
import com.amazon.kindle.util.lipc.LipcService;
import com.amazon.kindle.util.lipc.LipcSource;
import com.github.chrox.kpvbooklet.util.Log;
import java.io.PrintStream;

class BookletTimer {
    private static final String timersource = "com.github.koreader.kpvbooklet.timer";
    private static final PrintStream logger = Log.INSTANCE;
    private static int counter = 0;

    BookletTimer() {
    }

    public static int getCounter() {
        return counter;
    }

    public static void addCounter(int count) {
        counter += count;
    }

    public static void addBookletCounter() {
        try {
            LipcSource source = LipcService.getInstance().createSource(timersource);
            TimerProperties timerproperty = new TimerProperties();
            source.exportIntProperty("count", (LipcPropertyProvider)timerproperty, 1);
            source.exportIntProperty("add", (LipcPropertyProvider)timerproperty, 2);
            source.exportIntProperty("set", (LipcPropertyProvider)timerproperty, 2);
            source.exportIntProperty("reset", (LipcPropertyProvider)timerproperty, 2);
        }
        catch (LipcException e) {
            logger.println("E: " + e.toString());
            e.printStackTrace(logger);
        }
    }

    private static class TimerProperties
    extends LipcPropertyAdapter {
        private TimerProperties() {
        }

        public int getIntProperty(String property) throws LipcException {
            if (property.equals("count")) {
                return counter;
            }
            return 0;
        }

        public void setProperty(String property, int val) throws LipcException {
            if (property.equals("set")) {
                counter = val;
            } else if (property.equals("add")) {
                counter = counter + val;
            } else if (property.equals("reset")) {
                counter = 0;
            }
        }
    }
}

