/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrox.kpvbooklet.dictadapter;

import com.github.chrox.kpvbooklet.util.KindleDevice;
import com.github.chrox.kpvbooklet.util.Log;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.json.simple.JSONValue;

public abstract class DictAdapter {
    protected static Class Framework = null;
    protected static Class ReaderSDK = null;
    protected static Class DictMgr = null;
    protected static Class Dictionary = null;
    protected static Class ResultEntry = null;
    protected static Class Definition = null;
    protected static Class DictView = null;
    protected static Class DictControl = null;
    protected static Class DictPos = null;
    protected static Class SystemsCardProvider = null;
    protected static Class DictionaryCard = null;
    protected static Class ShowDictionaryCard = null;
    public static final DictAdapter INSTANCE = DictAdapter.getAdapterInstance();
    protected static final PrintStream logger = Log.INSTANCE;

    private static DictAdapter getAdapterInstance() {
        String version = KindleDevice.VERSION;
        String className = "";
        if ("5.3.5".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery535";
        } else if ("5.3.4".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery534";
        } else if ("5.3.3".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery533";
        } else if ("5.3.2".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery532";
        } else if ("5.3.1".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery531";
        } else if ("5.3.0".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery530";
        } else if ("5.2.0".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery520";
        } else if ("5.1.2".equals(version)) {
            className = "com.github.chrox.kpvbooklet.dictadapter.DictQuery512";
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (DictAdapter)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to instantiate class: " + className);
        }
    }

    public void log(String msg) {
        logger.println(msg);
    }

    public JPanel getDictView(String word) {
        try {
            Object dict = this.getDicts()[0];
            Object result = this.getResultSet(dict, word);
            Object cardprovider = SystemsCardProvider.newInstance();
            Object readersdk = Framework.getDeclaredMethod(this.getServiceMethod(), Class.class).invoke(null, ReaderSDK);
            Field sdkfield = SystemsCardProvider.getDeclaredField("l");
            sdkfield.setAccessible(true);
            sdkfield.set(cardprovider, readersdk);
            Object dictcard = DictionaryCard.getConstructor(SystemsCardProvider).newInstance(cardprovider);
            Field cardproviderfield = DictionaryCard.getDeclaredField("h");
            cardproviderfield.setAccessible(true);
            cardproviderfield.set(dictcard, cardprovider);
            Constructor constructor = ShowDictionaryCard.getDeclaredConstructor(DictionaryCard, String.class);
            constructor.setAccessible(true);
            Object showdictcard = constructor.newInstance(dictcard, "");
            Field dictfield = ShowDictionaryCard.getDeclaredField("B");
            dictfield.setAccessible(true);
            dictfield.set(showdictcard, dict);
            Field resultfield = ShowDictionaryCard.getDeclaredField("e");
            resultfield.setAccessible(true);
            resultfield.set(showdictcard, result);
            Field wordfield = DictionaryCard.getDeclaredField("f");
            wordfield.setAccessible(true);
            wordfield.set(dictcard, word);
            Field showcardfield = DictionaryCard.getDeclaredField("i");
            showcardfield.setAccessible(true);
            showcardfield.set(dictcard, showdictcard);
            this.log("I: Name: " + this.getDictName(dict));
            this.log("I: Lang: " + this.getDictLanguage(dict));
            this.log("I: ID: " + this.getDictID(dict));
            Object pos = ResultEntry.getField("l").get(result);
            Dictionary.getDeclaredMethod("TU", DictPos).invoke(dict, pos);
            Integer position = (Integer)DictPos.getDeclaredMethod("at", new Class[0]).invoke(pos, null);
            this.log("I: word position: " + position.toString());
            Object dictcontrol = Dictionary.getDeclaredMethod("Ns", new Class[0]).invoke(dict, null);
            Object dictview = DictControl.getDeclaredMethod("ET", Dictionary, ResultEntry).invoke(dictcontrol, dict, result);
            JPanel panel = new JPanel();
            DictView.getDeclaredMethod("bu", JPanel.class).invoke(dictview, panel);
            panel.list(logger);
            return panel;
        }
        catch (Throwable t) {
            this.log("E: " + t.toString());
            t.printStackTrace(logger);
            return null;
        }
    }

    public String query(String word) {
        try {
            Object[] dicts = this.getDicts();
            LinkedList results_list = new LinkedList();
            for (int i = 0; i < dicts.length; ++i) {
                Object dict = dicts[i];
                Object resultset = this.getResultSet(dict, word);
                if (resultset == null) continue;
                LinkedHashMap<String, String> query_result = new LinkedHashMap<String, String>();
                query_result.put("dict", this.getDictName(dict));
                query_result.put("lang", this.getDictLanguage(dict));
                query_result.put("ID", this.getDictID(dict));
                query_result.put("definition", this.getDictDefinition(resultset));
                results_list.add(query_result);
            }
            return JSONValue.toJSONString(results_list);
        }
        catch (Throwable t) {
            this.log("E: " + t.toString());
            return "";
        }
    }

    private Object[] getDicts() {
        try {
            Object readersdk = Framework.getDeclaredMethod(this.getServiceMethod(), Class.class).invoke(null, ReaderSDK);
            Object dictmgr = ReaderSDK.getDeclaredMethod(this.getDictMgrMethod(), new Class[0]).invoke(readersdk, null);
            List dicts = (List)DictMgr.getDeclaredMethod(this.getAllDictsMethod(), new Class[0]).invoke(dictmgr, null);
            return dicts.toArray();
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
            throw new RuntimeException(t.toString());
        }
    }

    private Object getResultSet(Object dict, String word) {
        try {
            return Dictionary.getDeclaredMethod(this.getLookupWordMethod(), String.class, String.class).invoke(dict, word, "");
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
            throw new RuntimeException(t.toString());
        }
    }

    private String getDictName(Object dict) {
        try {
            return (String)Dictionary.getDeclaredMethod(this.getDictNameMethod(), new Class[0]).invoke(dict, null);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    private String getDictLanguage(Object dict) {
        try {
            return (String)Dictionary.getDeclaredMethod(this.getLanguageOutMethod(), new Class[0]).invoke(dict, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    private String getDictID(Object dict) {
        try {
            return (String)Dictionary.getDeclaredMethod(this.getDictIDMethod(), new Class[0]).invoke(dict, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    private String getDictDefinition(Object result) {
        try {
            if (this.getResultsField().length() == 0) {
                return (String)ResultEntry.getField(this.getDefinitionField()).get(result);
            }
            int index = (Integer)ResultEntry.getField(this.getResultIndexField()).get(result);
            Object[] definitions = (Object[])ResultEntry.getField(this.getResultsField()).get(result);
            return (String)Definition.getField(this.getDefinitionField()).get(definitions[index]);
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
            throw new RuntimeException(t.toString());
        }
    }

    protected abstract String getServiceMethod();

    protected abstract String getDictMgrMethod();

    protected abstract String getAllDictsMethod();

    protected abstract String getLookupWordMethod();

    protected abstract String getLanguageInMethod();

    protected abstract String getLanguageOutMethod();

    protected abstract String getDictNameMethod();

    protected abstract String getDictTitleMethod();

    protected abstract String getDictIDMethod();

    protected abstract String getResultsField();

    protected abstract String getResultIndexField();

    protected abstract String getDefinitionField();
}

