/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrox.kpvbooklet;

import com.amazon.ebook.booklet.reader.ReaderBooklet;
import com.github.chrox.kpvbooklet.BookletTimer;
import com.github.chrox.kpvbooklet.ccadapter.CCAdapter;
import com.github.chrox.kpvbooklet.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URI;

public class KPVBooklet
extends ReaderBooklet {
    private final String koreader = "/mnt/us/koreader/koreader.sh";
    private final String kor_history = "/mnt/us/koreader/history/";
    private final String kpdfview = "/mnt/us/kindlepdfviewer/kpdf.sh";
    private final String kpv_history = "/mnt/us/kindlepdfviewer/history/";
    private final String gandalf = "/var/local/mkk/gandalf";
    private final String su = "/var/local/mkk/su";
    private static String PRIVILEGE_HINT_PREFIX = "?";
    private Process readerProcess;
    private String history_dir;
    private CCAdapter ccrequest = CCAdapter.INSTANCE;
    private static final PrintStream logger = Log.INSTANCE;

    public KPVBooklet() {
        String currentUsername = System.getProperty("user.name");
        PRIVILEGE_HINT_PREFIX = "root".equals(currentUsername) ? "#" : (new File("/var/local/mkk/gandalf").exists() ? "$" : "%");
        this.log("I: KPVBooklet");
        BookletTimer.addBookletCounter();
    }

    public void start(URI contentURI) {
        String[] cmd;
        String ext;
        this.log("I: start()");
        this.log("I: kpvbooklet launching times " + BookletTimer.getCounter());
        this.log("I: contentURI " + contentURI.toString());
        String path = contentURI.getPath();
        int dot = path.lastIndexOf(46);
        String string = ext = dot == -1 ? "" : path.substring(dot + 1).toLowerCase();
        if (ext.equals("pdf") && contentURI.getQuery() != null) {
            this.log("I: Opening " + path + " with native reader...");
            super.start(contentURI);
            return;
        }
        this.log("I: Opening " + path + " with koreader...");
        if ("$".equals(PRIVILEGE_HINT_PREFIX)) {
            this.log("I: Call Gandalf for help...");
            cmd = new String[]{"/var/local/mkk/su", "-s", "/bin/ash", "-c", "/mnt/us/koreader/koreader.sh \"" + path + "\""};
        } else {
            cmd = new String[]{"/bin/sh", "/mnt/us/koreader/koreader.sh", path};
        }
        try {
            this.readerProcess = Runtime.getRuntime().exec(cmd);
            this.history_dir = "/mnt/us/koreader/history/";
        }
        catch (IOException e) {
            this.readerProcess = null;
            this.log("W: koreader not found, will check legacy kindlepdfviewer instead.");
        }
        if (this.readerProcess == null) {
            this.log("I: Opening " + path + " with kindlepdfviewer...");
            cmd[cmd.length - 2] = "/mnt/us/kindlepdfviewer/kpdf.sh";
            this.history_dir = "/mnt/us/kindlepdfviewer/history/";
            try {
                this.readerProcess = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                this.log("E: " + e.toString());
            }
        }
        ReaderWaitThread thread = new ReaderWaitThread(this.history_dir, path);
        thread.start();
    }

    public void stop() {
        this.log("I: stop()");
        this.log("I: add kpvbooklet launching times");
        BookletTimer.addCounter(1);
        if (this.readerProcess != null) {
            try {
                this.killQuitProcess(this.readerProcess);
                this.log("I: reader process killed with return value " + this.readerProcess.exitValue());
            }
            catch (Exception e) {
                this.log("E: " + e.toString());
            }
        }
        super.stop();
    }

    private void killQuitProcess(Process process) throws InterruptedException, IOException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (!process.getClass().getName().equals("java.lang.UNIXProcess")) {
            throw new IllegalArgumentException("Needs to be a UNIXProcess");
        }
        Class<?> cl = process.getClass();
        Field field = cl.getDeclaredField("pid");
        field.setAccessible(true);
        Object pidObject = field.get(process);
        Runtime.getRuntime().exec("kill -QUIT " + pidObject).waitFor();
    }

    private float extractPercentFinished(String history_dir, String path) {
        float percent_finished = 0.0f;
        int slash = path.lastIndexOf(47);
        String parentname = slash == -1 ? "" : path.substring(0, slash + 1);
        String basename = slash == -1 ? "" : path.substring(slash + 1);
        String histroypath = history_dir + "[" + parentname.replace('/', '#') + "] " + basename + ".lua";
        this.log("I: found history file: " + histroypath);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(histroypath)));
            while ((line = br.readLine()) != null) {
                if (line.indexOf("[\"percent_finished\"]") <= -1) continue;
                this.log("I: found percent_finished line: " + line);
                int equal = line.lastIndexOf(61);
                int comma = line.lastIndexOf(44);
                if (equal == -1 || comma == -1) continue;
                String value = line.substring(equal + 1, comma).trim();
                value = value.replace(',', '.');
                percent_finished = Float.parseFloat(value) * 100.0f;
            }
            br.close();
        }
        catch (IOException e) {
            this.log("E: " + e.toString());
        }
        return percent_finished;
    }

    private void log(String msg) {
        logger.println(msg);
    }

    class ReaderWaitThread
    extends Thread {
        private String history_dir = "";
        private String content_path = "";

        public ReaderWaitThread(String dir, String path) {
            this.history_dir = dir;
            this.content_path = path;
        }

        public void run() {
            try {
                KPVBooklet.this.readerProcess.waitFor();
            }
            catch (InterruptedException e) {
                KPVBooklet.this.log("E: " + e.toString());
            }
            try {
                KPVBooklet.this.ccrequest.updateCC(this.content_path, KPVBooklet.this.extractPercentFinished(this.history_dir, this.content_path));
            }
            catch (Exception e) {
                KPVBooklet.this.log("E: " + e.toString());
            }
            try {
                Runtime.getRuntime().exec("lipc-set-prop com.lab126.appmgrd backward 0");
            }
            catch (IOException e) {
                KPVBooklet.this.log("E: " + e.toString());
            }
        }
    }
}

