#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

from __future__ import unicode_literals, division, absolute_import, print_function

import sys
import os
import re

try:
    from urllib.parse import unquote
except ImportError:
    from urllib import unquote

from sanitycheck import SanityCheck


# the plugin entry point
def run(bk):

    # walk all xhtml/html files sanity checking each one
    for mid, href in bk.text_iter():
        apath = unquote(href)
        filename = os.path.split(apath)[1]
        print("sanity checking ... ", filename, end="")

        sc = SanityCheck(bk.readfile(mid))

        has_error, errlist = sc.check()
        if has_error:
            print("     ", 'failed')
            for line, col, msg in errlist:
                msg += '.  near column %d' % col
                msg = re.sub('\'', '&apos;',  msg) 
                msg = re.sub('"', '&quot;',  msg) 
                msg = re.sub('<', '&lt;;',  msg) 
                msg = re.sub('>', '&gt;',  msg)
                bk.add_result('error', filename, line, msg)
                print("         line: ", line, " ", msg)
        else :
            print("     ", 'passed')
    
    # Setting the proper Return value is important.
    # 0 - means success
    # anything else means failure
    return 0
 

def main():
    print("I reached main when I should not have\n")
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

