/*
 * Decompiled with CFR 0.152.
 */
package highlightConverter.test;

import highlightConverter.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void getStringFromCurrentPositionTest() {
        ArrayList<Character> tab = new ArrayList<Character>();
        String s = "0123456789azerty";
        int i = 0;
        while (i < s.length()) {
            tab.add(Character.valueOf(s.charAt(i)));
            ++i;
        }
        Assert.assertEquals("0", StringUtil.getStringFromCurrentPosition(tab, 0, 1));
        Assert.assertEquals("123456789azerty", StringUtil.getStringFromCurrentPosition(tab, 1, 15));
        Assert.assertEquals("y", StringUtil.getStringFromCurrentPosition(tab, 15, 1));
        Assert.assertEquals("y", StringUtil.getStringFromCurrentEndPositionReadingBackwards(tab, 16, 1));
        Assert.assertEquals("0", StringUtil.getStringFromCurrentEndPositionReadingBackwards(tab, 1, 1));
        Assert.assertEquals("123456789azerty", StringUtil.getStringFromCurrentEndPositionReadingBackwards(tab, 16, 15));
    }

    @Test
    public void sansHTMLtest() throws IOException {
        String texteDocument = "Bodin imagine que sept personnages, qui tous pratiquent la m\u00e9decine<a title=\"\" href=\"http://russeurope.hypotheses.org/3253#_ftn10\">[10]</a> et qui professent tous une foi diff\u00e9rente, sont r\u00e9unis dans un ch\u00e2teau. Chacun son tour, ils vont chercher \u00e0 convaincre les six autres.";
        String texteHighlight = "Bodin imagine que sept personnages, qui tous pratiquent la m\u00e9decine[10] et qui professent tous une foi diff\u00e9rente, sont r\u00e9unis dans un ch\u00e2teau. Chacun son tour, ils vont chercher \u00e0 convaincre les six autres.";
        Assert.assertTrue(StringUtil.getWithoutHtmlAndSpacesString(texteHighlight).equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
    }

    @Test
    public void sansHTMLtest2() throws IOException {
        String texteDocument = "Mais, derri\u00e8re l\u2019apparence d\u2019une mont\u00e9e de la religiosit\u00e9, c\u2019est en r\u00e9alit\u00e9 \u00e0 une mont\u00e9e des affirmations identitaires et narcissiques que l\u2019on assiste. Les crispations autour des tabous alimentaires et vestimentaires, sur les signes ext\u00e9rieurs (comme la question du voile chez les musulmans) ont avant tout pour but d\u2019identifier brutalement une communaut\u00e9, de la s\u00e9parer du reste de la population et de l\u2019enfermer sur des r\u00e9f\u00e9rences mythifi\u00e9es pour le plus grand profit de quelques uns. Ces pratiques, en produisant des mouvements de r\u00e9actions, font en r\u00e9alit\u00e9 progresser la division des individus entre eux au lieu d\u2019y mettre fin.";
        String texteHighlight = "Mais, derri\u00e8re l\u2019apparence d\u2019une mont\u00e9e de la religiosit\u00e9, c\u2019est en r\u00e9alit\u00e9 \u00e0 une mont\u00e9e des affirmations identitaires et narcissiques que l\u2019on assiste. Les crispations autour des tabous alimentaires et vestimentaires, sur les signes ext\u00e9rieurs (comme la question du voile chez les musulmans) ont avant tout pour but d\u2019identifier brutalement une communaut\u00e9, de la s\u00e9parer du reste de la population et de l\u2019enfermer sur des r\u00e9f\u00e9rences mythifi\u00e9es pour le plus grand profit de quelques uns. Ces pratiques, en produisant des mouvements de r\u00e9actions, font en r\u00e9alit\u00e9 progresser la division des individus entre eux au lieu d\u2019y mettre fin.";
        Assert.assertTrue(StringUtil.getWithoutHtmlAndSpacesString(texteHighlight).equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
    }

    @Test
    public void sansHTMLtest3() throws IOException {
        String texteDocument = "L\u2019invention de la sph\u00e8re priv\u00e9e, et du cantonnement de la foi \u00e0 cette derni\u00e8re, ne prend sens <i>que</i> parce que des personnes de fois diff\u00e9rentes <i>se doivent de cohabiter ensemble</i>. Que Jean Bodin insiste sur l\u2019action en commun de personnes aux convictions religieuses diff\u00e9rentes est tr\u00e8s important. Cela veut dire qu\u2019il y a des choses communes, des <i>Res Publica</i>, qui sont plus importantes que les religions.";
        String texteHighlight = "L\u2019invention de la sph\u00e8re priv\u00e9e, et du cantonnement de la foi \u00e0 cette derni\u00e8re, ne prend sens que parce que des personnes de fois diff\u00e9rentes se doivent de cohabiter ensemble. Que Jean Bodin insiste sur l\u2019action en commun de personnes aux convictions religieuses diff\u00e9rentes est tr\u00e8s important. Cela veut dire qu\u2019il y a des choses communes, des Res Publica, qui sont plus importantes que les religions.";
        Assert.assertTrue(StringUtil.getWithoutHtmlAndSpacesString(texteHighlight).equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
    }

    @Test
    public void sansHTMLtest4() throws IOException {
        String texteDocument = "Naturellement, c\u2019est \u00e0 chaque fois un \u00e9chec, et pour une raison simple : la foi n\u2019est pas affaire de raison. Quand le septi\u00e8me de ces personnages a parl\u00e9 se pose alors une question redoutable : que vont-ils faire ?\n \nLa r\u00e9ponse est \u00e9clairante \u00e0 deux titres. La premi\u00e8re est qu\u2019ils d\u00e9cident de ne plus parler entre eux de religion, autrement dit celle-ci est exclue du d\u00e9bat public et devient une \u00ab affaire priv\u00e9e \u00bb, m\u00eame si, par courtoisie, ils s\u2019engagent tous \u00e0 aller aux c\u00e9l\u00e9brations des uns et des autres. La seconde est qu\u2019ils d\u00e9cident d\u2019\u0153uvrer en commun \u00ab pour les bien des hommes \u00bb. Une autre fin aurait \u00e9t\u00e9 possible. Ils auraient pu d\u00e9cider de se s\u00e9parer et de travailler s\u00e9par\u00e9ment chacun dans leur communaut\u00e9. Il y a l\u00e0 la seconde \u00ab invention \u00bb de Bodin.";
        String texteHighlight = "Naturellement, c\u2019est \u00e0 chaque fois un \u00e9chec, et pour une raison simple&nbsp;: la <i>foi</i> n\u2019est pas affaire de <i>raison</i>. Quand le septi\u00e8me de ces personnages a parl\u00e9 se pose alors une question redoutable&nbsp;: que vont-ils faire&nbsp;?</p>\n<p>La r\u00e9ponse est \u00e9clairante \u00e0 deux titres. La premi\u00e8re est qu\u2019ils d\u00e9cident de ne plus parler entre eux de religion, autrement dit <i>celle-ci est exclue du d\u00e9bat public</i> et devient une \u00ab&nbsp;affaire priv\u00e9e&nbsp;\u00bb, m\u00eame si, par courtoisie, ils s\u2019engagent tous \u00e0 aller aux c\u00e9l\u00e9brations des uns et des autres. La seconde est <i>qu\u2019ils d\u00e9cident d\u2019\u0153uvrer en commun \u00ab&nbsp;pour les bien des hommes&nbsp;\u00bb</i>. Une autre fin aurait \u00e9t\u00e9 possible. Ils auraient pu d\u00e9cider de se s\u00e9parer et de travailler s\u00e9par\u00e9ment chacun dans leur communaut\u00e9. Il y a l\u00e0 la seconde \u00ab&nbsp;invention&nbsp;\u00bb de Bodin.";
        Assert.assertTrue(StringUtil.getWithoutHtmlAndSpacesString(texteHighlight).equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
    }

    @Test
    public void sansHTMLtest5() throws IOException {
        String texteDocument = "/a>], lui-m\u00eame aussi droitier qu\u2019elles toutes. Mais comme l\u2019atteste \u00e9galement la permanence de l\u2019indigent r\u00e9flexe \u00ab intellectuel \u00bb qui retourne syst\u00e9matiquement \u00e0 l\u2019explication morale des choses, ou \u00e0 l\u2019explication des choses par la morale, en l\u2019occurrence l\u2019\u00ab \u00e9go\u00efsme \u00bb, quand \u00e9videmment la \u00ab solidarit\u00e9 \u00bb r\u00e8glerait tous nos probl\u00e8mes \u2013 mis\u00e8re d\u2019une construction politique qui n\u2019a plus que le recours de la vertu pour esp\u00e9rer contenir ses tares cong\u00e9nitales.</p>\n<p nodeindex=\"25\">Or rien, dans cette affaire allemande, n\u2019a \u00e0 voir ni avec la";
        String texteHighlight = "a>],lui-m\u00eameaussidroitierqu\u2019ellestoutes.Maiscommel\u2019atteste\u00e9galementlapermanencedel\u2019indigentr\u00e9flexe\u00abintellectuel\u00bbquiretournesyst\u00e9matiquement\u00e0l\u2019explicationmoraledeschoses,ou\u00e0l\u2019explicationdeschosesparlamorale,enl\u2019occurrencel\u2019\u00ab\u00e9go\u00efsme\u00bb,quand\u00e9videmmentla\u00absolidarit\u00e9\u00bbr\u00e8gleraittousnosprobl\u00e8mes\u2013mis\u00e8red\u2019uneconstructionpolitiquequin\u2019aplusquelerecoursdelavertupouresp\u00e9rercontenirsestarescong\u00e9nitales.Orrien,danscetteaffaireallemande,n\u2019a\u00e0voirniavecla";
        System.out.println("");
        System.out.println("texte avant       : " + texteDocument);
        System.out.println("texte apr\u00e8s       : " + StringUtil.getWithoutHtmlAndSpacesString(texteDocument));
        System.out.println("texte highlight   : " + StringUtil.getWithoutHtmlAndSpacesString(texteHighlight));
        Assert.assertFalse("Orrien,danscetteaffaireallemande,n\u2019a\u00e0voirniavecla".equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
        Assert.assertTrue(StringUtil.getWithoutHtmlAndSpacesString(texteHighlight).equals(StringUtil.getWithoutHtmlAndSpacesString(texteDocument)));
    }
}

