/*
 * Decompiled with CFR 0.152.
 */
package highlightConverter.test;

import highlightConverter.ProcessDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ProcessDocTest {
    @Test
    public void trouvePositionTexteTest1() throws IOException {
        File fichierDoc = new File("test/processDocTest.txt");
        fichierDoc.delete();
        FileWriter fw = new FileWriter(fichierDoc);
        fw.write("<html> et voil\u00e0 les amis </html>");
        fw.close();
        String passageASurligner = "voil\u00e0";
        int[] resultat = ProcessDoc.trouvePositionTexte(fichierDoc, passageASurligner, 0);
        Assert.assertEquals(10L, resultat[0]);
        Assert.assertEquals(15L, resultat[1]);
    }

    @Test
    public void trouvePositionTexteTest2() throws IOException {
        File fichierDoc = new File("test2/index.html");
        String passageASurligner = "Or rien, dans cette affaire allemande, n\u2019a \u00e0 voir ni avec la";
        int[] resultat = ProcessDoc.trouvePositionTexte(fichierDoc, passageASurligner, 0);
        Assert.assertEquals(9777L, resultat[0]);
        Assert.assertEquals(9837L, resultat[1]);
    }

    @Test
    public void trouvePositionTexteTest3() throws IOException {
        File fichierDoc = new File("test2/index.html");
        String passageASurligner = "Or rien";
        int[] resultat = ProcessDoc.trouvePositionTexte(fichierDoc, passageASurligner, 0);
        Assert.assertEquals(9777L, resultat[0]);
        Assert.assertEquals(9784L, resultat[1]);
    }

    @Test
    public void trouvePositionTexteTest4() throws IOException {
        File fichierDoc = new File("test2/index.html");
        String passageASurligner = "Or rien, dans cette affaire allemande, n\u2019a \u00e0 voir ni avec la \u00ab droite \u00bb ni avec l\u2019\u00ab \u00e9go\u00efsme \u00bb, et tout avec la d\u00e9fense de principes \u2013 qui n\u2019ont rien de moraux. Des principes mon\u00e9taires, inscrit dans une croyance collective, transpartisane, form\u00e9e \u00e0 l\u2019\u00e9preuve du trauma de l\u2019hyperinflation de 1923, con\u00e7ue, \u00e0 tort ou \u00e0 raison \u2013 en l\u2019occurrence \u00e0 tort \u2013, comme l\u2019antichambre du d\u00e9sastre maximal, le nazisme.";
        int[] resultat = ProcessDoc.trouvePositionTexte(fichierDoc, passageASurligner, 0);
        Assert.assertEquals(9777L, resultat[0]);
    }
}

