/*
 * Decompiled with CFR 0.152.
 */
package highlightConverter.test;

import highlightConverter.FileUtil;
import highlightConverter.ProcessDoc;
import highlightConverter.ProcessHighlighted;
import highlightConverter.ProcessTarget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class HiglightConverterTest {
    @Test
    public void highlightConverterTest1() throws IOException {
        File fichierHighlights;
        System.out.println("d\u00e9but : " + new Date());
        String[] args = new String[]{"test/index.html", "test/index.html_F_25f985fbcc6bc41c30045522e7650ed5.html"};
        File fichierDocument = new File(args[0]);
        if (!FileUtil.isFichierPresent(fichierDocument)) {
            System.exit(9);
        }
        if (!FileUtil.isFichierPresent(fichierHighlights = new File(args[1]))) {
            System.exit(9);
        }
        ArrayList<String> tabTexteSurligne = ProcessHighlighted.findHighlightedBlocks(fichierHighlights);
        ArrayList<int[]> positionsASurlignerTab = new ArrayList<int[]>();
        Iterator<String> it = tabTexteSurligne.iterator();
        int positionDepartRecherche = 0;
        while (it.hasNext()) {
            String s = it.next();
            int[] positionsTab = ProcessDoc.trouvePositionTexte(fichierDocument, s, positionDepartRecherche);
            positionsASurlignerTab.add(positionsTab);
            positionDepartRecherche = positionsTab[1];
        }
        Assert.assertEquals(8419L, ((int[])positionsASurlignerTab.get(0))[0]);
        Assert.assertEquals(9051L, ((int[])positionsASurlignerTab.get(0))[1]);
        Assert.assertEquals(19391L, ((int[])positionsASurlignerTab.get(1))[0]);
        Assert.assertEquals(19666L, ((int[])positionsASurlignerTab.get(1))[1]);
        Assert.assertEquals(19667L, ((int[])positionsASurlignerTab.get(2))[0]);
        Assert.assertEquals(20508L, ((int[])positionsASurlignerTab.get(2))[1]);
        Assert.assertEquals(20720L, ((int[])positionsASurlignerTab.get(3))[0]);
        Assert.assertEquals(21143L, ((int[])positionsASurlignerTab.get(3))[1]);
        File fichierCible = new File("test/cible.html");
        fichierCible.delete();
        System.out.println("\n--- applying highlight to target file... ");
        ArrayList<Character> tabCib = ProcessTarget.constitueTableauCible(fichierDocument, positionsASurlignerTab);
        fichierCible = FileUtil.fileFromTab(tabCib, "test/cible.html");
        System.out.println("fin   : " + new Date());
    }

    @Test
    public void highlightConverterTest2() throws IOException {
        File fichierHighlights;
        System.out.println("d\u00e9but : " + new Date());
        String[] args = new String[]{"test2/index.html", "test2/index.html_F_434590f44329f16a21102948317606eb.html", "test2/cible2.html"};
        File fichierDocument = new File(args[0]);
        if (!FileUtil.isFichierPresent(fichierDocument)) {
            System.exit(9);
        }
        if (!FileUtil.isFichierPresent(fichierHighlights = new File(args[1]))) {
            System.exit(9);
        }
        ArrayList<String> tabTexteSurligne = ProcessHighlighted.findHighlightedBlocks(fichierHighlights);
        ArrayList<int[]> positionsASurlignerTab = new ArrayList<int[]>();
        Iterator<String> it = tabTexteSurligne.iterator();
        int positionDepartRecherche = 0;
        while (it.hasNext()) {
            String s = it.next();
            int[] positionsTab = ProcessDoc.trouvePositionTexte(fichierDocument, s, positionDepartRecherche);
            positionsASurlignerTab.add(positionsTab);
            positionDepartRecherche = positionsTab[1];
        }
        Assert.assertEquals(9777L, ((int[])positionsASurlignerTab.get(0))[0]);
        Assert.assertEquals(10205L, ((int[])positionsASurlignerTab.get(0))[1]);
        File fichierCible = new File("test2/cible2.html");
        fichierCible.delete();
        System.out.println("\n--- applying highlight to target file... ");
        ArrayList<Character> tabCib = ProcessTarget.constitueTableauCible(fichierDocument, positionsASurlignerTab);
        fichierCible = FileUtil.fileFromTab(tabCib, "test2/cible2.html");
        System.out.println("fin   : " + new Date());
        System.out.println("fin   : " + new Date());
    }
}

