/*
 * Decompiled with CFR 0.152.
 */
package highlightConverter.test;

import highlightConverter.FileUtil;
import highlightConverter.ProcessTarget;
import highlightConverter.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilTest {
    private static String CHAINE_A_TROUVER = "Bodinimaginequeseptpersonnages,quitouspratiquentlam\u00e9decine[10]etquiprofessenttousunefoidiff\u00e9rente,sontr\u00e9unisdansunch\u00e2teau.Chacunsontour,ilsvontchercher\u00e0convaincrelessixautres.";

    @Test
    public void testEcritureFichierCible() throws IOException {
        File fichierDocument = new File("test/index.html");
        File fichierCible = new File("test/cible.html");
        ArrayList<int[]> positionsASurlignerTab = new ArrayList<int[]>();
        int[] resultat1 = new int[]{8419, 9051};
        int[] resultat2 = new int[]{19391, 19666};
        int[] resultat3 = new int[]{19667, 20508};
        int[] resultat4 = new int[]{20720, 21143};
        positionsASurlignerTab.add(resultat1);
        positionsASurlignerTab.add(resultat2);
        positionsASurlignerTab.add(resultat3);
        positionsASurlignerTab.add(resultat4);
        fichierCible.delete();
        ArrayList<Character> tabCib = ProcessTarget.constitueTableauCible(fichierDocument, positionsASurlignerTab);
        fichierCible = FileUtil.fileFromTab(tabCib, "test/cible.html");
    }

    @Test
    public void fileFromTabTest() throws IOException {
        ArrayList<Character> tab = new ArrayList<Character>();
        tab.add(Character.valueOf('a'));
        tab.add(Character.valueOf('b'));
        tab.add(Character.valueOf('c'));
        FileUtil.fileFromTab(tab, "test/testFileFromTab.txt");
        File fichier = new File("test/testFileFromTab.txt");
        ArrayList<Character> tab2 = FileUtil.tabFromFile(fichier);
        Assert.assertEquals(97L, tab2.get(0).charValue());
        Assert.assertEquals(98L, tab2.get(1).charValue());
        Assert.assertEquals(99L, tab2.get(2).charValue());
    }

    @Test
    public void tabFromFileTest() throws IOException {
        File fichierDocument = new File("test/index.html_F_25f985fbcc6bc41c30045522e7650ed5.html");
        ArrayList<Character> tabDoc = FileUtil.tabFromFile(fichierDocument);
        boolean testOk = false;
        int i = 0;
        while (i <= tabDoc.size()) {
            String chaine = StringUtil.getStringFromCurrentEndPositionReadingBackwards(tabDoc, i, 275);
            String chaineSansHtml = StringUtil.getWithoutHtmlAndSpacesString(chaine);
            if (chaine.startsWith("Bodin imagine")) {
                System.out.println("chaine                   /// lg=" + chaine.length() + ")" + chaine);
            }
            if (chaineSansHtml.startsWith("Bodinimagine")) {
                System.out.println("chaineSansHtml           /// lg=" + chaineSansHtml.length() + ")" + chaineSansHtml);
            }
            if (chaineSansHtml.equals(CHAINE_A_TROUVER)) {
                testOk = true;
            }
            ++i;
        }
        if (!testOk) {
            Assert.fail("\u00e9chec test");
        }
    }
}

