/*
 * Decompiled with CFR 0.152.
 */
package highlightConverter;

import highlightConverter.FileUtil;
import highlightConverter.ProcessDoc;
import highlightConverter.ProcessHighlighted;
import highlightConverter.ProcessTarget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class HighlightConverter {
    public static void main(String[] args) throws IOException {
        File fichierCible;
        File fichierHighlights;
        File fichierDocument;
        System.out.println("---------------------- HighlightConvert -----------------------");
        if (3 != args.length) {
            System.err.println("Usage is: java HighlightConvert fichierDocument fichierNotes fichierCible");
            System.exit(9);
        }
        if (!FileUtil.isFichierPresent(fichierDocument = new File(args[0]))) {
            System.err.println("File not found : " + fichierDocument);
            System.exit(9);
        }
        if (!FileUtil.isFichierPresent(fichierHighlights = new File(args[1]))) {
            System.err.println("File not found : " + fichierHighlights);
            System.exit(9);
        }
        if (FileUtil.isFichierPresent(fichierCible = new File(args[2]))) {
            System.out.println("\n--- target file will be deleted : " + fichierCible.getPath());
            fichierCible.delete();
        }
        ArrayList<String> tabTexteSurligne = ProcessHighlighted.findHighlightedBlocks(fichierHighlights);
        ArrayList<int[]> positionsASurlignerTab = new ArrayList<int[]>();
        System.out.println("\n--- search positions in original file... ");
        int positionDepartRecherche = 0;
        Iterator<String> it = tabTexteSurligne.iterator();
        int count = 1;
        while (it.hasNext()) {
            String s = it.next();
            int[] positionsTab = ProcessDoc.trouvePositionTexte(fichierDocument, s, positionDepartRecherche);
            positionsASurlignerTab.add(positionsTab);
            positionDepartRecherche = positionsTab[1];
            System.out.println("------ block " + count + " found in position " + positionsTab[0] + " -> " + positionsTab[1]);
            ++count;
        }
        System.out.println("\n--- applying highlight and generating result file " + fichierCible.getPath() + "...");
        ArrayList<Character> tabCib = ProcessTarget.constitueTableauCible(fichierDocument, positionsASurlignerTab);
        fichierCible = FileUtil.fileFromTab(tabCib, args[2]);
        System.out.println("\n--------------------------- fin -------------------------------");
    }
}

