# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__ = 'GPL v3'
__copyright__ = '2015, David Forrester <davidfor@internode.on.net>'
__docformat__ = 'markdown en'

import os
from cStringIO import StringIO

from calibre.utils.zipfile import safe_replace
from calibre.customize.builtins import EPUBMetadataWriter
from calibre.ebooks.metadata.epub import get_zip_reader
from calibre.ebooks.metadata import MetaInformation
from calibre.ebooks.oeb.polish.container import OPF_NAMESPACES
from calibre.ebooks.metadata.opf2 import OPF
from calibre.utils.localunzip import LocalZipFile

from calibre.devices.usbms.driver import debug_print

class KEPUBMetadataWriter(EPUBMetadataWriter):

    name        = 'Set KEPUB metadata'
    author      = 'David Forrester'
    file_types  = set(['kepub'])
    description = _('Set metadata to %s files')%'Kobo ePub'
    version                 = (0, 2, 0)
    minimum_calibre_version = (0, 1, 0)

    def set_metadata(self, stream, mi, type):
        import traceback
        traceback.print_stack()

        debug_print("KEPUBMetadataWriter::set_metadata - self.__class__=%s" %(self.__class__))
        super(KEPUBMetadataWriter, self).set_metadata(stream, mi, type)

#        traceback.print_stack()
        stream.seek(0)
        reader = get_zip_reader(stream, root=os.getcwdu())
        raster_cover = reader.opf.raster_cover
#        mi = MetaInformation(mi)

        found_cover = False
        covers = reader.opf.raster_cover_path(reader.opf.metadata)
        if covers:
            debug_print("KEPUBMetadataWriter::set_metadata - covers=", covers)
            cover_id = covers[0].get('content')
            debug_print("KEPUBMetadataWriter::set_metadata - cover_id=", cover_id)
            for item in reader.opf.itermanifest():
                if item.get('id', None) == cover_id:
                    mt = item.get('media-type', '')
                    if mt and 'xml' not in mt and 'html' not in mt:
                        debug_print("KEPUBMetadataWriter::set_metadata - found cover")
                        item.set("properties", "cover-image")
                        found_cover = True
            debug_print("KEPUBMetadataWriter::set_metadata - looking for cover using href")
            if found_cover:
                for item in reader.opf.itermanifest():
                    if item.get('href', None) == cover_id:
                        mt = item.get('media-type', '')
                        if mt and mt.startswith('image/'):
                            debug_print("KEPUBMetadataWriter::set_metadata -found cover")
                            item.set("properties", "cover-image")
                            found_cover = True

            if found_cover:
                newopf = StringIO(reader.opf.render())
                if isinstance(reader.archive, LocalZipFile):
                    reader.archive.safe_replace(reader.container[OPF.MIMETYPE], newopf)
                else:
                    safe_replace(stream, reader.container[OPF.MIMETYPE], newopf)

#        if raster_cover:
#            debug_print("KEPUBMetadataWriter::set_metadata - raster_cover=%s" %(raster_cover))
#            cover_meta_node = reader.opf.XPath('./opf:metadata/opf:meta[@name="cover"]')(reader.opf.metadata)
#            if len(cover_meta_node) > 0:
#                cover_meta_node = cover_meta_node[0]
#                cover_id = cover_meta_node.attrib["content"] if "content" in cover_meta_node.attrib else None
#                debug_print("KEPUBMetadataWriter::set_metadata - cover_id=", cover_id)
#                if cover_id is not None:
#                    print("KEPUBMetadataWriter:set_metadata:Found cover image ID '{0}'".format(cover_id))
#                    cover_node = reader.opf.xpath('./opf:manifest/opf:item[@id="{0}"]'.format(cover_id), namespaces=OPF_NAMESPACES)
#                    if len(cover_node) > 0:
#                        cover_node = cover_node[0]
#                        if "properties" not in cover_node.attrib or cover_node.attrib["properties"] != "cover-image":
#                            print("KEPUBMetadataWriter:set_metadata:Setting cover-image property")
#                            cover_node.set("properties", "cover-image")
#                            found_cover = True
#            # It's possible that the cover image can't be detected this way. Try looking for the cover image ID in the OPF manifest.
#            if not found_cover:
#                print("KEPUBMetadataWriter:set_metadata:Looking for cover image in OPF manifest")
#                node_list = reader.opf.XPath('./opf:manifest/opf:item[(@id="cover" or starts-with(@id, "cover")) and starts-with(@media-type, "image")]')(reader.opf.metadata)
#                debug_print("KEPUBMetadataWriter::set_metadata - node_list=", node_list)
#                if len(node_list) > 0:
#                    node = node_list[0]
#                    if "properties" not in node.attrib or node.attrib["properties"] != 'cover-image':
#                        print("KEPUBMetadataWriter:set_metadata:Setting cover-image")
#                        node.set("properties", "cover-image")
#                        found_cover = True

