# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__ = 'GPL v3'
__copyright__ = '2015, David Forrester <davidfor@internode.on.net>'
__docformat__ = 'markdown en'

import os, re, posixpath
from calibre.utils.zipfile import ZipFile, BadZipfile, safe_replace
from calibre.utils.localunzip import LocalZipFile
from calibre.ebooks.metadata.epub import get_zip_reader, render_cover
from calibre.customize.builtins import EPUBMetadataReader

class KEPUBMetadataReader(EPUBMetadataReader):

    name        = 'Read KEPUB metadata'
    author      = 'David Forrester'
    description = _('Read metadata from %s files') % 'Kobo ePub'
    file_types  = set(['kepub'])
    version                 = (0, 2, 0)
    minimum_calibre_version = (0, 1, 0)

