﻿using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;

namespace XRayBuilderGUI
{
    public partial class frmSettings : Form
    {
        public frmSettings()
        {
            InitializeComponent();
        }

        private void frmSettings_Load(object sender, EventArgs e)
        {
            txtOut.Text = XRayBuilderGUI.Properties.Settings.Default.outDir;
            txtUnpack.Text = XRayBuilderGUI.Properties.Settings.Default.mobi_unpack;
            chkSpoilers.Checked = XRayBuilderGUI.Properties.Settings.Default.spoilers;
            chkRaw.Checked = XRayBuilderGUI.Properties.Settings.Default.saverawml;
            chkSoftHyphen.Checked = XRayBuilderGUI.Properties.Settings.Default.ignoresofthyphen;
            chkUseNew.Checked = XRayBuilderGUI.Properties.Settings.Default.useNewVersion;
            txtOffset.Text = XRayBuilderGUI.Properties.Settings.Default.offset.ToString();
            chkAndroid.Checked = XRayBuilderGUI.Properties.Settings.Default.android;
            txtReal.Text = XRayBuilderGUI.Properties.Settings.Default.realName;
            txtPen.Text = XRayBuilderGUI.Properties.Settings.Default.penName;
            chkEnableEdit.Checked = XRayBuilderGUI.Properties.Settings.Default.enableEdit;
            chkSubDirectories.Checked = XRayBuilderGUI.Properties.Settings.Default.useSubDirectories;
            chkUTF8.Checked = XRayBuilderGUI.Properties.Settings.Default.utf8;
            if (txtUnpack.Text == "") txtUnpack.Text = "dist/kindleunpack.exe";
            chkAmazonUK.Checked = XRayBuilderGUI.Properties.Settings.Default.amazonUk;

            Version dd = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
            string xrayversion = dd.Major.ToString() + "." + dd.Minor.ToString() +
                dd.Build.ToString() + "." + dd.Revision.ToString();
            lblVersion.Text = "X-ray Builder GUI v" + xrayversion;

            // Added \r\n to show smaller tooltips
            ToolTip ToolTip1 = new ToolTip();
            ToolTip1.SetToolTip(chkRaw,
                "Save the .rawml (raw markup) of the book\r\nin the output directory so you can review it.");
            ToolTip1.SetToolTip(chkSpoilers, "Use Shelfari descriptions that\r\ncontain spoilers when they exist.");
            ToolTip1.SetToolTip(txtOffset,
                "This offset will be applied to every book location\r\n(usually a negative number). Must be an integer.");
            ToolTip1.SetToolTip(chkSoftHyphen,
                "Ignore soft hyphens (Unicode U+00AD) while searching\r\nfor terms. This may slow down the parsing process slightly.");
            ToolTip1.SetToolTip(chkUseNew,
                "Write the X-ray file in the new format for Paperwhite 2\r\nor Voyage firmware 5.6+. Massively slower than the\r\nnormal build process and is still in alpha testing.");
            ToolTip1.SetToolTip(chkAndroid,
                "Changes the naming convention of the X-ray file for the\r\nAndroid Kindle app. Forces building with the new format.");
            ToolTip1.SetToolTip(chkUTF8, "Write the X-Ray file in UTF8 instead of ANSI.");
            ToolTip1.SetToolTip(txtReal, "Required for the EndActions.data file creation.");
            ToolTip1.SetToolTip(txtPen, "Required for the EndActions.data file creation.");
            ToolTip1.SetToolTip(chkAmazonUK,
                "Search Amazon.co.uk first, use Amazon.com as fallback.\r\n(Amazon.com is used if Amazon.co.uk is not selected.)");
            ToolTip1.SetToolTip(chkEnableEdit,
                "Open Notepad to enable editing of detected Chapters\r\nand Aliases before final X-ray creation.");
            ToolTip1.SetToolTip(chkSubDirectories, "Save generated files to an \"Author - Book\" subdirectory.");
            ToolTip1.SetToolTip(btnLogs, "Open the log files directory.");
            //this.TopMost = true;
        }

        private void btnBrowseUnpack_Click(object sender, EventArgs e)
        {
            txtUnpack.Text = Functions.GetExe(txtUnpack.Text);
        }

        private void btnBrowseOut_Click(object sender, EventArgs e)
        {
            txtOut.Text = Functions.GetDir(txtOut.Text);
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            int offset = 0;
            if (!int.TryParse(txtOffset.Text, out offset))
            {
                MessageBox.Show("The offset must be an integer.", "Offset Error");
                return;
            }
            if (txtReal.Text.Trim().Length == 0 | txtPen.Text.Trim().Length == 0)
            {
                MessageBox.Show("Both Real and Pen names are required for\r\nEnd Action file creation.");
                return;
            }

            XRayBuilderGUI.Properties.Settings.Default.outDir = txtOut.Text;
            XRayBuilderGUI.Properties.Settings.Default.mobi_unpack = txtUnpack.Text;
            XRayBuilderGUI.Properties.Settings.Default.spoilers = chkSpoilers.Checked;
            XRayBuilderGUI.Properties.Settings.Default.saverawml = chkRaw.Checked;
            XRayBuilderGUI.Properties.Settings.Default.ignoresofthyphen = chkSoftHyphen.Checked;
            XRayBuilderGUI.Properties.Settings.Default.useNewVersion = chkUseNew.Checked;
            XRayBuilderGUI.Properties.Settings.Default.android = chkAndroid.Checked;
            XRayBuilderGUI.Properties.Settings.Default.utf8 = chkUTF8.Checked;
            XRayBuilderGUI.Properties.Settings.Default.offset = offset;
            XRayBuilderGUI.Properties.Settings.Default.realName = txtReal.Text;
            XRayBuilderGUI.Properties.Settings.Default.penName = txtPen.Text;
            XRayBuilderGUI.Properties.Settings.Default.amazonUk = chkAmazonUK.Checked;
            XRayBuilderGUI.Properties.Settings.Default.enableEdit = chkEnableEdit.Checked;
            XRayBuilderGUI.Properties.Settings.Default.useSubDirectories = chkSubDirectories.Checked;
            XRayBuilderGUI.Properties.Settings.Default.Save();

            this.Close();
        }

        private void chkAndroid_CheckedChanged(object sender, EventArgs e)
        {
            if (chkAndroid.Checked == true)
            {
                chkUseNew.Checked = true;
                chkUseNew.Enabled = false;
            }
            else
                chkUseNew.Enabled = true;
        }

        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            if (keyData == Keys.Escape)
            {
                this.Close();
                return true;
            }
            return base.ProcessCmdKey(ref msg, keyData);
        }

        private void btnLogs_Click(object sender, EventArgs e)
        {
            if (!Directory.Exists(Environment.CurrentDirectory + @"\log"))
            {
                MessageBox.Show("Log directory does not exist.", "Logs Directory Not found");
                return;
            }
            else
                this.TopMost = false;
            Process.Start(Environment.CurrentDirectory + @"\log");
        }
    }
}