#!/bin/sh

# Directory of this script
dir=`/usr/bin/dirname $0`

# Directory of the launcher
launchdir="$dir/../../sh/"

# Current date/time
date=`date +%a\ %b\ %d\ %R`

# Location of xshell
location=`"$launchdir/launch.sh" --preserve-manifest --location`

# If finding a location succeeded,
if test $? -eq 0 ; then
  result="Found at $location on $date"
else
  result="No installation of xshell/mrxvt v0.5.0 or higher found."
fi


# Create a new manifest.xml.  The newline is a valid character inside the quotes,
# and this counts as one line of code.
"$dir/manifest.sh" "Check installation status" "Click here to update the result.
$result" "$date" run.sh
