uninstallerversion=050

# Set the working directory to the directory of this script
scriptdir=`/usr/bin/dirname $0`
cd "$scriptdir"

# If there's a launch.sh in this directory, then use it.
# Otherwise, assume we're in the installer menu, so we
# know the relative path to launch.sh in the sh directory.
if test -x ./launch.sh ; then   
  launcher=./launch.sh
else
  launcher=../../sh/launch.sh
fi

yesnoprompt() {
  if test -n "$1" ; then
    params="-p"
  else
    params=
  fi
  while :
  do
    read $params "$1" input
    case $input in
    y | Y | yes | YES | Yes)
      return 0 ;;
    n | N | no | NO | No)
      return 1 ;;
    esac
    echo "Response unrecognized.  Please answer y/n."
  done
}

echo "Checking for existing versions..."
location=`"$launcher" 2>/dev/null --location`
if test $? -ne 0 ; then
  echo "No existing versions of xshell interface 0.5.0 or greater found."
  exit 1  
else
  version=`"$location/startxshell" --xshellversion`
  versionnum=`"$location/startxshell" --xshellversionnum`
  echo "The following version of xshell has been found."
  echo "$location: $version"
  echo
  if test $versionnum -gt $uninstallerversion ; then
    echo "Warning: This uninstaller was not designed to remove this version."
    echo "It is suggested that you abort removal and run the correct "
    echo "uninstaller."
    echo
  fi
  yesnoprompt "Would you like to continue with uninstallation? (y/n)+<Enter>: "
  if test $? -eq 1 ; then
    echo "Removal aborted."
    exit 1
  fi 
fi

echo "Removing $HOME/.xshell"
rm "$HOME/.xshell"
echo "Removing $location/xshell.cfg"
rm "$location/xshell.cfg"
echo "Removing $location/prerun"
rm "$location/prerun"
echo "Removing $location/startxshell"
rm "$location/startxshell"
echo "Removing mrxvt"
rm -Rf "$location/mrxvt"
echo "Removing $location"
rmdir "$location"

if test $? -ne 0 ; then
  echo "Uninstall failed."
else
  echo "Uninstall successful."
fi

echo

yesnoprompt "Would you like to remove shortcuts to the command shell? (y/n)+<Enter>: "
if test $? -eq 0 ; then
  if test -d /mnt/free/sh ; then
    echo "Removing /mnt/free/sh"
    rm -Rf /mnt/free/sh
  fi
  if test -d /usr/local/programs/sh ; then
    echo "Removing /usr/local/programs/sh"
    rm -Rf /usr/local/programs/sh
  fi
  if test -d /usr/local/programs/Uninstall/sh ; then
    echo "Removing /usr/local/programs/Uninstall/sh"
    rm -Rf /usr/local/programs/Uninstall/sh
    rm /usr/local/programs/Uninstall/_shell.png
  fi
fi
echo "Finished."
echo 
