﻿Imports System.IO
Imports System.Text
Imports System.Text.RegularExpressions
Imports Microsoft.VisualBasic.FileIO
Imports System.Windows.Forms



Public Class progbOpenFile

    Public sOpenedBook As String
    Public sOpenedImage As String
    Public sCoverImagePreview As String
    Public sThumbnailImagePreview As String
    Public sOpenedImageOutput As String
    Public sOpenedTNImage As String
    Public sOpenedTNImageOutput As String
    Public sGen3FixOutput As String
    Public sBookTitle As String
    Public sLongTitle As String
    Public sBookAuthor As String
    Public sBookAuthorResult As String
    Public sBookAuthorOutput As String
    Public sBookPublisher As String
    Public sBookPublisherResult As String
    Public sBookPublisherOutput As String
    Public sBookSubject As String
    Public sBookSubjectResult As String
    Public sBookSubjectOutput As String
    Public sBookDescription As String
    Public sBookDescriptionResult As String
    Public sBookDescriptionOutput As String
    Public sBookLanguage As String
    Public sBookLanguageResult As String
    Public sBookLanguageOutput As String
    Public sBookType As String
    Public sBookTypeResult As String
    Public sBookTypeOutput As String
    Public sFilenameTrimmed As String
    Public sFilenameOutput As String
    Public sFilenameOutputMod As String
    Public sFilenameOutputCheck As String
    Public sFilenameOutputFinal As String
    Public sCoverImagePreviewPath As String
    Public sThumbnailImagePreviewPath As String
    Public sCoverImagePreviewPathBatch As String
    Public sThumbnailImagePreviewPathBatch As String
    Public sOutPutPath As String
    Public sDatafileDetail As String
    Public sLongfileDetail As String
    Public sSearchResult As String
    Public Shared sSplit As String()
    Public Shared sSplitData As String()
    Public content As String
    Public sMobiDataPathBatch As String
    Public sMobiDataPath As String
    Public sTmpBookPath As String
    Public sTmpBookPathBatch As String
    Public sMobi2MobiPath As String
    Public sM2MBatchPath As String
    Public sFilterExtn As String
    Public sExth1 As String
    Public sExth1Output As String
    Public sDeleteOutput As String
    Public sDeleteIndexOutput As String
    Public sClippingLimitOutput As String
    Public sTTSFlagOutput As String



    Private Sub btnMobi2MobiDir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMobi2MobiDir.Click

        Dim theFolderBrowser As New FolderBrowserDialog

        Dim folderDialog As New FolderBrowserDialog()
        folderDialog.ShowNewFolderButton = False
        folderDialog.SelectedPath = "C:\"
        folderDialog.Description = "Select the directory the Mobi2Mobi Win32 or Perl file resides in."

        If folderDialog.ShowDialog() = DialogResult.OK Then
            Me.tbMobi2MobiDir.Text = folderDialog.SelectedPath
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "MobiDir", tbMobi2MobiDir.Text)

        End If

        Dim sMobi2MobiPL As String = tbMobi2MobiDir.Text & "\mobi2mobi.pl"
        Dim sMobi2MobiEX As String = tbMobi2MobiDir.Text & "\mobi2mobi.exe"

        If File.Exists(sMobi2MobiPL) Then
            Me.cbUsePerl.Visible = True
            Me.cbUsePerl.Checked = True

        Else
            Me.cbUsePerl.Visible = False

        End If

        If File.Exists(sMobi2MobiEX) Then
            Me.cbUseWin32.Visible = True
            Me.cbUseWin32.Checked = True

        Else
            Me.cbUseWin32.Visible = False

        End If

        If Me.cbUsePerl.Visible = False And Me.cbUseWin32.Visible Then
            Me.cbUseWin32.Location = New System.Drawing.Point(532, 29)
            Me.cbUseWin32.Checked = True

        Else
            Me.cbUseWin32.Location = New System.Drawing.Point(604, 29)

        End If

        If Me.cbUsePerl.Visible Or Me.cbUseWin32.Visible Then
            Me.lblMobi2MobiNotFound.Visible = False

        Else
            Me.lblMobi2MobiNotFound.Visible = True

        End If


    End Sub

    Private Sub btnBookDir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBookDir.Click

        Dim folderDialog As New FolderBrowserDialog()
        folderDialog.ShowNewFolderButton = False
        folderDialog.SelectedPath = "C:\"
        folderDialog.Description = "Select the directory your eBooks reside in."

        If folderDialog.ShowDialog() = DialogResult.OK Then
            Me.tbBookDir.Text = folderDialog.SelectedPath
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "BookDir", tbBookDir.Text)

        End If

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim objIniFile As New IniFile(".\m2mcfg.ini")

        nudDeleteIndex.Visible = False
        cbDeleteIndex.Visible = False
        cbClippingLimit.Visible = False
        cbTTSFlag.Visible = False
        cbASAZW.Visible = False
        cbASAZW.Checked = False

        tbMobi2MobiDir.Text = objIniFile.GetString("Config", "MobiDir", "(Select a directory)")
        tbBookDir.Text = objIniFile.GetString("Config", "BookDir", "(Select a directory)")

        If tbMobi2MobiDir.Text = "(Select a directory)" Then
            MsgBox("Please select the location of the Mobi2Mobi Win32 or Perl file.")
            Me.cbUsePerl.Visible = False
            Me.cbUseWin32.Visible = False
        Else
            Dim sMobi2MobiPL As String = tbMobi2MobiDir.Text + "\mobi2mobi.pl"
            Dim sMobi2MobiEX As String = tbMobi2MobiDir.Text + "\mobi2mobi.exe"

            If File.Exists(sMobi2MobiPL) Then
                Me.cbUsePerl.Visible = True

            Else
                Me.cbUsePerl.Visible = False

            End If

            If File.Exists(sMobi2MobiEX) Then
                Me.cbUseWin32.Visible = True

            Else
                Me.cbUseWin32.Visible = False

            End If

            If Me.cbUsePerl.Visible = False And Me.cbUseWin32.Visible Then
                Me.cbUseWin32.Location = New System.Drawing.Point(532, 29)
                Me.cbUseWin32.Checked = True

            Else
                Me.cbUseWin32.Location = New System.Drawing.Point(604, 29)

            End If

            If Me.cbUsePerl.Visible Or Me.cbUseWin32.Visible Then
                Me.lblMobi2MobiNotFound.Visible = False

            Else
                Me.lblMobi2MobiNotFound.Visible = True

            End If

        End If

        Dim cbPerlState As String = objIniFile.GetString("Config", "UsePerl", "false")
        Dim cbWin32State As String = objIniFile.GetString("Config", "UseWin32", "false")

        If cbPerlState = "true" Then
            Me.cbUsePerl.Checked = True

        Else
            Me.cbUsePerl.Checked = False

        End If

        If cbWin32State = "true" Then
            Me.cbUseWin32.Checked = True

        Else
            Me.cbUseWin32.Checked = False

        End If

    End Sub

    Private Sub cbUsePerl_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbUsePerl.CheckedChanged

        If Me.cbUsePerl.Checked = True Then
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "UsePerl", "true")
            objIniFile.WriteString("Config", "UseWin32", "false")
            Me.cbUseWin32.Checked = False

        Else
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "UsePerl", "false")
            objIniFile.WriteString("Config", "UseWin32", "true")
            Me.cbUseWin32.Checked = True

        End If

        If Me.cbUseWin32.Visible = False Then
            Me.cbUsePerl.Checked = True

        End If

    End Sub

    Private Sub cbUseWin32_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbUseWin32.CheckedChanged

        If Me.cbUseWin32.Checked = True Then
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "UsePerl", "false")
            objIniFile.WriteString("Config", "UseWin32", "true")
            Me.cbUsePerl.Checked = False

        Else
            Dim objIniFile As New IniFile(".\m2mcfg.ini")
            objIniFile.WriteString("Config", "UsePerl", "true")
            objIniFile.WriteString("Config", "UseWin32", "false")
            Me.cbUsePerl.Checked = True

        End If

        If Me.cbUsePerl.Visible = False Then
            Me.cbUseWin32.Checked = True

        End If
    End Sub

    Private Sub InitFields()

        sOpenedImage = ""
        sOpenedImageOutput = ""
        sOpenedTNImage = ""
        sOpenedTNImageOutput = ""
        sGen3FixOutput = ""
        sFilterExtn = ""
        sMobiDataPath = ""
        sMobiDataPathBatch = ""
        sTmpBookPath = ""
        sTmpBookPathBatch = ""
        sMobi2MobiPath = ""
        sM2MBatchPath = ""
        sOutPutPath = ""
        sOpenedBook = ""
        sBookTitle = ""
        sLongTitle = ""
        sBookAuthor = ""
        sBookAuthorResult = ""
        sBookAuthorOutput = ""
        sBookPublisher = ""
        sBookPublisherResult = ""
        sBookPublisherOutput = ""
        sBookSubject = ""
        sBookSubjectResult = ""
        sBookSubjectOutput = ""
        sBookDescription = ""
        sBookDescriptionResult = ""
        sBookDescriptionOutput = ""
        sBookLanguage = ""
        sBookLanguageResult = ""
        sBookLanguageOutput = ""
        sBookType = ""
        sBookTypeResult = ""
        sBookTypeOutput = ""
        sFilenameTrimmed = ""
        sFilenameOutput = ""
        sFilenameOutputMod = ""
        sFilenameOutputCheck = ""
        sFilenameOutputFinal = ""
        sDatafileDetail = ""
        sLongfileDetail = ""
        sCoverImagePreview = ""
        sThumbnailImagePreview = ""
        sCoverImagePreviewPath = ""
        sThumbnailImagePreviewPath = ""
        sCoverImagePreviewPathBatch = ""
        sThumbnailImagePreviewPathBatch = ""
        sExth1 = ""
        sExth1Output = ""
        sDeleteOutput = ""
        sDeleteIndexOutput = ""

        cbOutputFile.Checked = False
        cbBookTitle.Checked = False
        cbAuthorDetail.Checked = False
        cbPublisherDetail.Checked = False
        cbSubject.Checked = False
        cbDescription.Checked = False
        cbLanguage.Checked = False
        cbThumbnail.Checked = False
        cbCoverImage.Checked = False
        cbGen3Fix.Checked = False
        cbExth1.Checked = False
        cbBookType.Checked = False
        cbDelete.Checked = False
        cbDeleteIndex.Checked = False
        cbClippingLimit.Checked = False
        cbTTSFlag.Checked = False
        cbASAZW.Checked = False

        cbClippingLimit.Visible = False
        cbTTSFlag.Visible = False
        cbASAZW.Visible = False

        rtbMobiOutput.Text = ""

        pbCoverImage.Image = Nothing
        pbThumbnail.Image = Nothing

        nudDeleteIndex.Value = 0

        cmbLanguage.SelectedIndex = -1
        cmbexthType1.SelectedIndex = -1
        cmbBookType.SelectedIndex = -1
        cmbDeleteTypeData.SelectedIndex = -1

        tbOpenedFile.Text = ""
        tbOutputFile.Text = ""
        tbBookTitle.Text = ""
        tbAuthorDetail.Text = ""
        tbPublisherDetail.Text = ""
        tbSubject.Text = ""
        tbDescription.Text = ""
        tbLanguage.Text = ""
        tbCoverImage.Text = ""
        tbexthData1.Text = ""
        tbBookType.Text = ""

    End Sub

    Private Sub btnOpenFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpenFile.Click
        If lblMobi2MobiNotFound.Visible = True Then
            MessageBox.Show("Please select the location of the Mobi2Mobi Win32 or Perl file.")

        Else
            InitFields()

            Dim theFileBrowser As New OpenFileDialog()
            theFileBrowser.InitialDirectory = tbBookDir.Text
            theFileBrowser.Filter = "MobiPocket/Kindle (*.prc, *.mobi, *.azw, *.azw3)|*.prc;*.mobi;*.azw;*.azw3"
            theFileBrowser.Title = "Select a MobiPocket/Kindle File"

            BuildPaths()

            DelFile(sTmpBookPath)
            DelFile(sCoverImagePreviewPath)
            DelFile(sThumbnailImagePreviewPath)

            If theFileBrowser.ShowDialog = Windows.Forms.DialogResult.OK Then
                sOpenedBook = theFileBrowser.FileName
                tbOpenedFile.Text = theFileBrowser.SafeFileName
                sOutPutPath = LeftOf(sOpenedBook, tbOpenedFile.Text)
                sFilterExtn = RightOf(sOpenedBook, ".")
                sOpenedBook = """" & sOpenedBook & """"

                BuildBatch(sM2MBatchPath, ((((sMobi2MobiPath & " ") + sOpenedBook & " --outfile ") + sTmpBookPathBatch & " --savecover ") + sCoverImagePreviewPathBatch & " --savethumb ") + sThumbnailImagePreviewPathBatch)

                BatchProcess(sM2MBatchPath, False)

                DelFile(sM2MBatchPath)

                BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sTmpBookPathBatch & " > ") + sMobiDataPathBatch)

                rtbMobiOutput.Text = BatchProcess(sM2MBatchPath, True)

                If rtbMobiOutput.Text = "" And sFilterExtn = "azw" Then

                    DelFile(sM2MBatchPath)
                    BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sOpenedBook & " > ") + sMobiDataPathBatch)
                    rtbMobiOutput.Text = BatchProcess(sM2MBatchPath, True)

                    UpdateBookFields(sMobiDataPath, True)

                    sSplit = sDatafileDetail.Split(":"c)
                    sDatafileDetail = RightOf(sSplit(1), " ")
                    Array.Clear(sSplit, 0, sSplit.Length)

                    If sDatafileDetail = "" Then

                        DelFile(sM2MBatchPath)
                        BuildBatch(sM2MBatchPath, (((sMobi2MobiPath & " ") + sOpenedBook & " --databasename ") + LeftOf(tbOpenedFile.Text, ".") & " --outfile ") + sTmpBookPathBatch)
                        BatchProcess(sM2MBatchPath, False)
                        DelFile(sM2MBatchPath)
                        BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sTmpBookPathBatch & " > ") + sMobiDataPathBatch)
                        rtbMobiOutput.Text = BatchProcess(sM2MBatchPath, True)

                        MessageBox.Show("It looks like your AZW file did not have an entry in the DATABASENAME field. The filename of this AZW file has been added as the DATABASENAME.")
                    End If
                End If

                UpdateCoverImagePB(sCoverImagePreviewPath)
                UpdateThumbnailImagePB(sThumbnailImagePreviewPath)

                DelFile(sM2MBatchPath)

                sFilenameOutput = LeftOf(tbOpenedFile.Text, ".")
                tbOutputFile.Text = sFilenameOutput
                sFilenameOutputCheck = sFilenameOutput
                sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutput & ".mobi" & """"

                UpdateBookFields(sMobiDataPath, True)

                sBookTitle = tbBookTitle.Text
                sLongTitle = tbBookTitle.Text
                sLongTitle = ("--title " & """") + sLongTitle & """" & " "

                DelFile(sMobiDataPath)

            End If


        End If

    End Sub

    Public Shared Function LeftOf(ByVal stream As String, ByVal stringToStopAt As String) As String
        Try
            If stringToStopAt Is Nothing OrElse stringToStopAt = String.Empty Then
                Return stream
            End If

            Dim stringLength As Integer = stream.Length
            Dim findLength As Integer = stringToStopAt.Length

            stringToStopAt = stringToStopAt.ToLower()
            Dim temp As String = stream.ToLower()
            Dim i As Integer = temp.IndexOf(stringToStopAt)

            If (i <= -1) AndAlso (stringToStopAt <> temp.Substring(0, findLength)) OrElse (i = -1) Then
                Return stream
            End If

            Dim result As String = stream.Substring(0, i)
            Return result
        Catch generatedExceptionName As Exception
            'ErrorTool.ProcessError(ex); 
            Return Nothing
        End Try
    End Function

    Public Shared Function RightOf(ByVal stream As String, ByVal stringToStartAfter As String) As String
        Try
            If stringToStartAfter Is Nothing OrElse stringToStartAfter = String.Empty Then
                Return stream
            End If

            stringToStartAfter = stringToStartAfter.ToLower()
            Dim temp As String = stream.ToLower()
            Dim findLength As Integer = stringToStartAfter.Length
            Dim i As Integer = temp.IndexOf(stringToStartAfter)

            If (i <= -1) AndAlso (stringToStartAfter <> temp.Substring(0, findLength)) OrElse (i = -1) Then
                Return stream
            End If

            Dim result As String = stream.Substring(i + findLength, stream.Length - (i + findLength))
            Return result
        Catch generatedExceptionName As Exception
            'ErrorTool.ProcessError(ex); 
            Return Nothing
        End Try
    End Function

    Private Sub BuildPaths()
        sCoverImagePreviewPath = tbMobi2MobiDir.Text & "\cover.m2m"
        sCoverImagePreviewPathBatch = """" & sCoverImagePreviewPath & """"

        sThumbnailImagePreviewPath = tbMobi2MobiDir.Text & "\thumb.m2m"
        sThumbnailImagePreviewPathBatch = """" & sThumbnailImagePreviewPath & """"

        sMobiDataPath = tbMobi2MobiDir.Text & "\mobidata.m2m"
        sMobiDataPathBatch = """" & sMobiDataPath & """"

        sTmpBookPath = tbMobi2MobiDir.Text & "\tmpBook.m2m"
        sTmpBookPathBatch = """" & sTmpBookPath & """"

        If Me.cbUsePerl.Checked = True Then
            sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.pl"
            sMobi2MobiPath = """" & sMobi2MobiPath & """"
        Else
            sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.exe"
            sMobi2MobiPath = """" & sMobi2MobiPath & """"
        End If

        sM2MBatchPath = tbMobi2MobiDir.Text & "\m2mcmds.bat"
    End Sub

    Private Sub BuildBatch(ByVal path As String, ByVal output As String)
        ' The following is always in UTF8
        ' Dim swBat As StreamWriter = File.CreateText(path)
        ' Write in system local encoding instead
        Dim swBat As New StreamWriter(path, False, System.Text.Encoding.[Default])
        swBat.WriteLine(output)
        'swBat.WriteLine("pause")
        swBat.Close()
    End Sub

    Private Function BatchProcess(ByVal batchfile As String, ByVal output As Boolean) As String

        Dim p As Process = Nothing
        Try
            p = New Process()
            p.StartInfo.FileName = batchfile
            p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden
            p.StartInfo.UseShellExecute = False
            p.StartInfo.CreateNoWindow = True
            p.Start()
            p.WaitForExit()
        Catch ex As Exception

            Console.WriteLine("Exception Occurred :{0},{1}", ex.Message, ex.StackTrace.ToString())
        End Try

        If output = True Then
            Dim objInput As New StreamReader(sMobiDataPath, System.Text.Encoding.[Default])
            Dim res As String = objInput.ReadToEnd().Trim()
            objInput.Dispose()
            objInput.Close()
            p.Close()
            Return res.Replace(Chr(0), "")
        Else
            p.Close()
            Return Nothing
        End If
    End Function

    Private Sub UpdateCoverImagePB(ByVal imagefile As String)
        If File.Exists(imagefile) = True Then
            Dim fsImage As New FileStream(imagefile, FileMode.Open, FileAccess.Read)
            Dim tmpImage As Image = Image.FromStream(fsImage)
            pbCoverImage.Image = tmpImage
            fsImage.Dispose()
            fsImage.Close()
        End If
    End Sub

    Private Sub UpdateThumbnailImagePB(ByVal imagefile As String)
        If File.Exists(imagefile) = True Then
            Dim fsImage As New FileStream(imagefile, FileMode.Open, FileAccess.Read)
            Dim tmpImage As Image = Image.FromStream(fsImage)
            pbThumbnail.Image = tmpImage
            fsImage.Dispose()
            fsImage.Close()
        End If
    End Sub

    Private Sub UpdateBookFields(ByVal datapath As String, ByVal open As Boolean)
        Dim objInput As New StreamReader(datapath, System.Text.Encoding.[Default])
        Dim sClip As String = ""
        Dim sTTS As String = ""

        content = objInput.ReadToEnd().Trim()
        sSplitData = System.Text.RegularExpressions.Regex.Split(content, vbCr, RegexOptions.None)
        objInput.Dispose()
        objInput.Close()


        sDatafileDetail = FindMatch("Database Name:")
        sLongfileDetail = FindMatch("LONGTITLE:")
        sBookAuthorResult = FindMatch("EXTH    item: 100 - Author -")
        sBookPublisherResult = FindMatch("EXTH    item: 101 - Publisher -")
        sBookSubjectResult = FindMatch("EXTH    item: 105 - Subject -")
        sBookDescriptionResult = FindMatch("EXTH    item: 103 - Description -")
        sBookLanguageResult = FindMatch("MOBIHEADER language:")
        sBookTypeResult = FindMatch("MOBIHEADER booktype:")
        sClip = FindMatch("EXTH    item: 401")
        sTTS = FindMatch("EXTH    item: 404")

        If open = True Then
            If sFilterExtn.Contains("prc") Then
                sSplit = sDatafileDetail.Split(":"c)
                tbBookTitle.Text = RightOf(sSplit(1), " ")
                Array.Clear(sSplit, 0, sSplit.Length)
                cbBookTitle.Checked = True

            End If

        End If

        If sFilterExtn.Contains("mobi") Then
            sSplit = sLongfileDetail.Split(":"c)
            tbBookTitle.Text = RightOf(sSplit(1), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sFilterExtn.Contains("azw") Then
            sSplit = sLongfileDetail.Split(":"c)
            tbBookTitle.Text = RightOf(sSplit(1), " ")
            Array.Clear(sSplit, 0, sSplit.Length)
            cbASAZW.Visible = True
            cbASAZW.Checked = True

        End If

        If sTTS.Length > 0 Then
            cbTTSFlag.Visible = True

        End If

        If sClip.Length > 0 Then
            sSplit = sClip.Split("-"c)
            Dim sVal As String = RightOf(sSplit(3), " ")
            Array.Clear(sSplit, 0, sSplit.Length)
            sVal = RightOf(sVal, "x")
            Dim sCalc As String = Val("&H" + sVal)
            cbClippingLimit.Text = "Clipping Limit " + sCalc + "%"
            cbClippingLimit.Visible = True

        End If


        If sBookAuthorResult.Length > 0 Then
            sSplit = sBookAuthorResult.Split("-"c)
            tbAuthorDetail.Text = RightOf(sSplit(3), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sBookPublisherResult.Length > 0 Then
            sSplit = sBookPublisherResult.Split("-"c)
            tbPublisherDetail.Text = RightOf(sSplit(3), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sBookSubjectResult.Length > 0 Then
            sSplit = sBookSubjectResult.Split("-"c)
            tbSubject.Text = RightOf(sSplit(3), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sBookDescriptionResult.Length > 0 Then
            sSplit = sBookDescriptionResult.Split("-"c)
            tbDescription.Text = RightOf(sSplit(3), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sBookLanguageResult.Length > 0 Then
            sSplit = sBookLanguageResult.Split("-"c)
            Dim sBuildLanguage As String = ""

            If sSplit(3).Length > 1 Then
                sBuildLanguage = RightOf(sSplit(3), " ")

            End If

            tbLanguage.Text = sBuildLanguage
            Array.Clear(sSplit, 0, sSplit.Length)

        End If

        If sBookTypeResult.Length > 0 Then
            sSplit = sBookTypeResult.Split("-"c)
            tbBookType.Text = RightOf(sSplit(1), " ")
            Array.Clear(sSplit, 0, sSplit.Length)

        End If
    End Sub

    Private Function FindMatch(ByVal matchString As String) As String
        Dim match As String = ""

        For [loop] As Integer = 0 To sSplitData.Length - 1
            If sSplitData([loop]).Contains(matchString) Then
                match = sSplitData([loop])
                Return match
            End If
        Next
        match = ""
        Return match
    End Function

    Private Sub DelFile(ByVal path As String)
        If File.Exists(path) Then
            File.Delete(path)
        End If
    End Sub

    Private Sub cbOutputFile_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbOutputFile.CheckedChanged
        If Me.cbOutputFile.Checked = True Then
            sFilenameOutputMod = tbOutputFile.Text
            If sFilenameOutput <> sFilenameOutputMod = True Then
                sFilenameOutputCheck = sFilenameOutputMod

                If Me.cbASAZW.Visible And Me.cbASAZW.Checked Then
                    sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutputMod + ".azw" & """"

                Else
                    sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutputMod + ".mobi" & """"

                End If

            Else
                sFilenameOutputMod = sFilenameOutput
                sFilenameOutputCheck = sFilenameOutputMod
                cbOutputFile.Checked = False
                MessageBox.Show("You didn't make any changes to the output filename.")
            End If
        End If

        If Me.cbOutputFile.Checked = False Then
            sFilenameOutputMod = sFilenameOutput
            sFilenameOutputCheck = sFilenameOutputMod

            If Me.cbASAZW.Visible And Me.cbASAZW.Checked Then
                sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutputMod + ".azw" & """"

            Else
                sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutputMod + ".mobi" & """"

            End If

        End If

    End Sub

    Private Sub tbOutputFile_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbOutputFile.TextChanged
        If sFilenameOutput <> tbOutputFile.Text = False Then
            cbOutputFile.Checked = False
        End If
    End Sub

    Private Sub cbBookTitle_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbBookTitle.CheckedChanged
        If Me.cbBookTitle.Checked = True Then
            sLongTitle = tbBookTitle.Text
            If sBookTitle <> sLongTitle = True Then
                sLongTitle = ("--title " & """") + sLongTitle & """" & " "

                If sFilterExtn.Contains("azw") Then
                    sLongTitle = (sLongTitle & "--exthtype updatedtitle" & " " & "--exthdata " & """") + tbBookTitle.Text & """" & " "
                End If
            Else
                sLongTitle = sBookTitle
                cbBookTitle.Checked = False
                MessageBox.Show("You didn't make any changes to the Book Title.")

            End If
        End If

        If Me.cbBookTitle.Checked = False Then
            sLongTitle = sBookTitle
            sLongTitle = ("--title " & """") + sLongTitle & """" & " "

        End If
    End Sub

    Private Sub tbBookTitle_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbBookTitle.TextChanged
        If tbBookTitle.Text <> sBookTitle = True Then
            cbBookTitle.Checked = False

        End If
    End Sub

    Private Sub cbAuthorDetail_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbAuthorDetail.CheckedChanged
        If Me.cbAuthorDetail.Checked = True Then
            sBookAuthor = tbAuthorDetail.Text
            If sBookAuthor.Length > 0 Then
                sBookAuthorOutput = ("--author " & """") + sBookAuthor & """" & " "
            Else
                sBookAuthor = ""
                cbAuthorDetail.Checked = False
                MessageBox.Show("Please enter Authors name before checking this box again.")
            End If
        End If

        If Me.cbAuthorDetail.Checked = False Then
            sBookAuthorOutput = ""
        End If
    End Sub

    Private Sub cbPublisherDetail_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbPublisherDetail.CheckedChanged
        If Me.cbPublisherDetail.Checked = True Then
            sBookPublisher = tbPublisherDetail.Text
            If sBookPublisher.Length > 0 Then
                sBookPublisherOutput = ("--publisher " & """") + sBookPublisher & """" & " "
            Else
                sBookPublisher = ""
                cbPublisherDetail.Checked = False
                MessageBox.Show("Please enter the Publishers details before checking this box again.")
            End If
        End If

        If Me.cbPublisherDetail.Checked = False Then
            sBookPublisherOutput = ""
        End If
    End Sub

    Private Sub cbSubject_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbSubject.CheckedChanged
        If Me.cbSubject.Checked = True Then
            sBookSubject = tbSubject.Text
            If sBookSubject.Length > 0 Then
                sBookSubjectOutput = ("--subject " & """") + sBookSubject & """" & " "
            Else
                sBookSubject = ""
                cbSubject.Checked = False
                MessageBox.Show("Please enter subject details before checking this box again.")
            End If
        End If

        If Me.cbSubject.Checked = False Then
            sBookSubjectOutput = ""
        End If
    End Sub

    Private Sub cbDescription_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbDescription.CheckedChanged
        If Me.cbDescription.Checked = True Then
            sBookDescription = tbDescription.Text
            If sBookDescription.Length > 0 Then
                sBookDescriptionOutput = ("--description " & """") + sBookDescription & """" & " "
            Else
                sBookDescription = ""
                cbDescription.Checked = False
                MessageBox.Show("Please enter description details before checking this box again.")
            End If
        End If

        If Me.cbDescription.Checked = False Then
            sBookDescriptionOutput = ""
        End If
    End Sub

    Private Sub cbLanguage_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbLanguage.CheckedChanged
        Dim sSelectedLanguage As String = ""

        If Me.cbLanguage.Checked = True Then
            sSelectedLanguage = cmbLanguage.Text
            If sSelectedLanguage.Length > 0 Then
                sBookLanguageOutput = ("--language " & """") + sSelectedLanguage & """" & " "
            Else
                sSelectedLanguage = ""
                cbLanguage.Checked = False
                MessageBox.Show("Please select a language before checking this box again.")
            End If
        End If

        If Me.cbLanguage.Checked = False Then
            sBookLanguageOutput = ""
        End If
    End Sub

    Private Sub cbExth1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbExth1.CheckedChanged
        Dim sSelectedType As String = cmbexthType1.Text

        If Me.cbExth1.Checked = True Then

            If sSelectedType.Length > 0 Then
                sSelectedType = LeftOf(cmbexthType1.Text, " -")
                sExth1Output = "--exthtype " + sSelectedType + " --exthdata " & """" + tbexthData1.Text & """" & " "

            Else
                sSelectedType = ""
                cbExth1.Checked = False
                MessageBox.Show("Please select a Exth Type before checking this box again.")
            End If
        End If

        If Me.cbExth1.Checked = False Then
            sExth1Output = ""
        End If
    End Sub

    Private Sub btnCoverImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCoverImage.Click
        Dim openFileDialog1 As New OpenFileDialog()
        openFileDialog1.InitialDirectory = "" & tbBookDir.Text & ""
        openFileDialog1.Filter = "Image File (*.jpg, *.png)|*.jpg;*.png"
        openFileDialog1.Title = "Select a Cover Image for your eBook"

        If openFileDialog1.ShowDialog() = DialogResult.OK Then
            sOpenedImage = openFileDialog1.FileName
            tbCoverImage.Text = sOpenedImage
            pbCoverImage.Image = Image.FromFile(sOpenedImage)
        End If
    End Sub

    Private Sub cbCoverImage_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbCoverImage.CheckedChanged
        If Me.cbCoverImage.Checked = True Then
            If sOpenedImage.Length > 0 Then
                sOpenedImageOutput = ("--coverimage " & """") + sOpenedImage & """" & " "
            Else
                sOpenedImage = ""
                cbCoverImage.Checked = False
                MessageBox.Show("Please open an Image before checking this box again.")
            End If
        End If

        If Me.cbCoverImage.Checked = False Then
            sOpenedImageOutput = ""
        End If
    End Sub

    Private Sub cbThumbnail_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbThumbnail.CheckedChanged
        If Me.cbThumbnail.Checked = True Then
            If sOpenedImage.Length > 0 Then
                sOpenedTNImageOutput = ("--addthumbnail " & """") + sOpenedImage & """" & " "
            Else
                sOpenedImage = ""
                cbThumbnail.Checked = False
                MessageBox.Show("Please open an Image before checking this box again.")
            End If
        End If

        If Me.cbThumbnail.Checked = False Then
            sOpenedTNImageOutput = ""
        End If
    End Sub

    Private Sub cbGen3Fix_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbGen3Fix.CheckedChanged
        If Me.cbGen3Fix.Checked = True Then
            If sOpenedImage.Length > 0 Then
                sGen3FixOutput = "--gen3imagefix "
            Else
                sOpenedImage = ""
                cbGen3Fix.Checked = False
                MessageBox.Show("Please open an Image before checking this box again.")
            End If
        End If

        If Me.cbGen3Fix.Checked = False Then
            sGen3FixOutput = ""
        End If
    End Sub

    Private Sub btnCovert_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCovert.Click
        If tbOpenedFile.Text.Length <= 0 Then
            MessageBox.Show("Please open a Mobipocket eBook for conversion and try again.")

        Else

            If Me.cbUsePerl.Checked = True Then
                sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.pl"
                sMobi2MobiPath = """" & sMobi2MobiPath & """"
            Else
                sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.exe"
                sMobi2MobiPath = """" & sMobi2MobiPath & """"
            End If

            rtbMobiOutput.Text = ""

            BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sTmpBookPathBatch & " ") + sLongTitle + sBookAuthorOutput + sBookPublisherOutput + sBookSubjectOutput + sBookDescriptionOutput + sBookLanguageOutput + sBookTypeOutput + sExth1Output + sDeleteOutput + sDeleteIndexOutput + sOpenedImageOutput + sOpenedTNImageOutput + sGen3FixOutput + sClippingLimitOutput + sTTSFlagOutput + sFilenameOutputFinal)

            BatchProcess(sM2MBatchPath, False)

            DelFile(sTmpBookPath)

            DelFile(sM2MBatchPath)

            'BuildBatch(sM2MBatchPath, (sMobi2MobiPath & " " & """") + sOutPutPath + sFilenameOutputCheck & ".mobi" & """")

            'DelFile(sM2MBatchPath)

            'Reload New Converted File 
            pbCoverImage.Image = Nothing
            pbThumbnail.Image = Nothing

            DelFile(sCoverImagePreviewPath)
            DelFile(sThumbnailImagePreviewPath)

            If Me.cbASAZW.Visible And Me.cbASAZW.Checked Then
                sOpenedBook = sOutPutPath + sFilenameOutputCheck + ".azw"
                tbOpenedFile.Text = sFilenameOutputCheck + ".azw"
                sFilterExtn = RightOf(sOpenedBook, ".")

            Else
                sOpenedBook = sOutPutPath + sFilenameOutputCheck + ".mobi"
                tbOpenedFile.Text = sFilenameOutputCheck + ".mobi"
                sFilterExtn = RightOf(sOpenedBook, ".")

            End If

            sOutPutPath = LeftOf(sOpenedBook, tbOpenedFile.Text)
            sOpenedBook = """" & sOpenedBook & """"

            BuildBatch(sM2MBatchPath, ((((sMobi2MobiPath & " ") + sOpenedBook & " --outfile ") + sTmpBookPathBatch & " --savecover ") + sCoverImagePreviewPathBatch & " --savethumb ") + sThumbnailImagePreviewPathBatch)

            BatchProcess(sM2MBatchPath, False)

            DelFile(sM2MBatchPath)

            BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sTmpBookPathBatch & " > ") + sMobiDataPathBatch)

            rtbMobiOutput.Text = BatchProcess(sM2MBatchPath, True)

            UpdateCoverImagePB(sCoverImagePreviewPath)
            UpdateThumbnailImagePB(sThumbnailImagePreviewPath)

            DelFile(sM2MBatchPath)
            sFilenameOutput = LeftOf(tbOpenedFile.Text, ".")
            tbOutputFile.Text = sFilenameOutput
            sFilenameOutputCheck = sFilenameOutput

            If Me.cbASAZW.Visible And Me.cbASAZW.Checked Then
                sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutput + ".azw" & """"

            Else
                sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + sFilenameOutput + ".mobi" & """"

            End If

            cbClippingLimit.Visible = False
            cbTTSFlag.Visible = False
            cbClippingLimit.Checked = False
            cbTTSFlag.Checked = False
            cbASAZW.Checked = False
            cbASAZW.Visible = False

            UpdateBookFields(sMobiDataPath, False)

            sBookTitle = tbBookTitle.Text
            sLongTitle = tbBookTitle.Text
            sLongTitle = ("--title " & """") + sLongTitle & """" & " "

            DelFile(sMobiDataPath)

            nudDeleteIndex.Visible = False
            cbDeleteIndex.Visible = False

            cbOutputFile.Checked = False
            cbBookTitle.Checked = False
            cbAuthorDetail.Checked = False
            cbPublisherDetail.Checked = False
            cbSubject.Checked = False
            cbDescription.Checked = False
            cbLanguage.Checked = False
            cbBookType.Checked = False
            cbThumbnail.Checked = False
            cbCoverImage.Checked = False
            cbGen3Fix.Checked = False
            cbExth1.Checked = False
            cbDelete.Checked = False
            cbDeleteIndex.Checked = False

            tbCoverImage.Text = ""
            tbexthData1.Text = ""

            nudDeleteIndex.Value = 0
            cmbLanguage.SelectedIndex = -1
            cmbBookType.SelectedIndex = -1
            cmbexthType1.SelectedIndex = -1
            cmbDeleteTypeData.SelectedIndex = -1

        End If

    End Sub

    Private Sub cbBookType_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbBookType.CheckedChanged
        Dim sSelectedBookType As String = cmbBookType.Text

        If Me.cbBookType.Checked = True Then

            If sSelectedBookType.Length > 0 Then
                sSelectedBookType = LeftOf(cmbBookType.Text, " -")
                sBookTypeOutput = ("--booktype " & """") + sSelectedBookType & """" & " "
            Else
                sSelectedBookType = ""
                cbBookType.Checked = False
                MessageBox.Show("Please select a book type before checking this box again.")
            End If
        End If

        If Me.cbBookType.Checked = False Then
            sBookTypeOutput = ""
        End If
    End Sub


    Private Sub tbMobi2MobiDir_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbMobi2MobiDir.TextChanged

        Dim objIniFile As New IniFile(".\m2mcfg.ini")
        objIniFile.WriteString("Config", "MobiDir", tbMobi2MobiDir.Text)

        Dim sMobi2MobiPL As String = tbMobi2MobiDir.Text & "\mobi2mobi.pl"
        Dim sMobi2MobiEX As String = tbMobi2MobiDir.Text & "\mobi2mobi.exe"

        If File.Exists(sMobi2MobiPL) Then
            Me.cbUsePerl.Visible = True

        Else
            Me.cbUsePerl.Visible = False

        End If

        If File.Exists(sMobi2MobiEX) Then
            Me.cbUseWin32.Visible = True

        Else
            Me.cbUseWin32.Visible = False

        End If

        If Me.cbUsePerl.Visible = False And Me.cbUseWin32.Visible Then
            Me.cbUseWin32.Location = New System.Drawing.Point(532, 29)
            Me.cbUseWin32.Checked = True

        Else
            Me.cbUseWin32.Location = New System.Drawing.Point(604, 29)

        End If

        If Me.cbUsePerl.Visible Or Me.cbUseWin32.Visible Then
            Me.lblMobi2MobiNotFound.Visible = False

        Else
            Me.lblMobi2MobiNotFound.Visible = True

        End If

        Dim cbPerlState As String = objIniFile.GetString("Config", "UsePerl", "false")
        Dim cbWin32State As String = objIniFile.GetString("Config", "UseWin32", "false")

        If cbPerlState = "true" Then
            Me.cbUsePerl.Checked = True

        Else
            Me.cbUsePerl.Checked = False

        End If

        If cbWin32State = "true" Then
            Me.cbUseWin32.Checked = True

        Else
            Me.cbUseWin32.Checked = False

        End If

    End Sub

    Private Sub tbBookDir_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbBookDir.TextChanged

        Dim objIniFile As New IniFile(".\m2mcfg.ini")
        objIniFile.WriteString("Config", "BookDir", tbBookDir.Text)

    End Sub

    Private Sub btnBatch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBatch.Click

        If tbOpenedFile.Text.Length <= 0 Then
            MessageBox.Show("Please open a Mobipocket eBook for conversion and try again.")

        Else
            If Me.cbUsePerl.Checked = True Then
                sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.pl"
                sMobi2MobiPath = """" & sMobi2MobiPath & """"
            Else
                sMobi2MobiPath = tbMobi2MobiDir.Text & "\mobi2mobi.exe"
                sMobi2MobiPath = """" & sMobi2MobiPath & """"
            End If

            BuildBatch(sM2MBatchPath, ((sMobi2MobiPath & " ") + sTmpBookPathBatch & " ") + sLongTitle + sBookAuthorOutput + sBookPublisherOutput + sBookSubjectOutput + sBookDescriptionOutput + sBookLanguageOutput + sBookTypeOutput + sExth1Output + sDeleteOutput + sDeleteIndexOutput + sOpenedImageOutput + sOpenedTNImageOutput + sGen3FixOutput + sClippingLimitOutput + sTTSFlagOutput + sFilenameOutputFinal)
            Call Shell("explorer /select," & sM2MBatchPath, AppWinStyle.NormalFocus)

        End If

    End Sub

    Private Sub cbDelete_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbDelete.CheckedChanged
        Dim sSelectedDeleteType As String = cmbDeleteTypeData.Text

        If Me.cbDelete.Checked = True Then

            If sSelectedDeleteType.Length > 0 Then
                nudDeleteIndex.Visible = True
                cbDeleteIndex.Visible = True

                sSelectedDeleteType = LeftOf(cmbDeleteTypeData.Text, " -")
                sDeleteOutput = "--delexthtype" & " " + sSelectedDeleteType & " "

            Else
                sSelectedDeleteType = ""
                cbDelete.Checked = False
                MessageBox.Show("Please select a Deletion Type before checking this box again.")

                nudDeleteIndex.Visible = False
                cbDeleteIndex.Visible = False

            End If
        End If

        If Me.cbDelete.Checked = False Then
            sDeleteOutput = ""
            nudDeleteIndex.Visible = False
            cbDeleteIndex.Visible = False
        End If

    End Sub


    Private Sub cbDeleteIndex_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbDeleteIndex.CheckedChanged
        Dim sSelectedIndex As String = nudDeleteIndex.Value

        If Me.cbDeleteIndex.Checked Then
            sDeleteIndexOutput = "--delexthindex" & " " + sSelectedIndex & " "

        Else
            sSelectedIndex = ""
            cbDeleteIndex.Checked = False
            sDeleteIndexOutput = ""
            nudDeleteIndex.Value = 0

        End If
    End Sub

    Private Sub cbClippingLimit_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbClippingLimit.CheckedChanged
        If Me.cbClippingLimit.Checked Then
            sClippingLimitOutput = "--deleteclippinglimit" & " "

        Else
            cbClippingLimit.Checked = False
            sClippingLimitOutput = ""

        End If
    End Sub


    Private Sub cbTTSFlag_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbTTSFlag.CheckedChanged
        If Me.cbTTSFlag.Checked Then
            sTTSFlagOutput = "--allowtts" & " "

        Else
            cbTTSFlag.Checked = False
            sTTSFlagOutput = ""

        End If
    End Sub

    Private Sub cbASAZW_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbASAZW.CheckedChanged

        If Me.cbASAZW.Checked Then
            sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + tbOutputFile.Text + ".azw" & """"

        Else
            sFilenameOutputFinal = ("--outfile " & """") + sOutPutPath + tbOutputFile.Text + ".mobi" & """"

        End If

    End Sub

    Private Sub cmbexthType1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbexthType1.SelectedIndexChanged

    End Sub

    Private Sub tbOpenedFile_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbOpenedFile.TextChanged

    End Sub
End Class
