#!/usr/bin/perl -w
use Encode;
use Getopt::Mixed "nextOption";
use File::Spec;
use File::Basename;
use FindBin qw($RealBin);
use lib "$RealBin";

# change it to the Windows system encoding as match the codepage
my $system_encoding = "gbk";


use m2mrun;

my $needlog = 0;
my $logfilename = "convert_log.txt";
my $logf;

sub log {
	my $msg = shift;
	print $logf $msg if($needlog == 1);
}

if($needlog == 1) {
	my $logfile = File::Spec->catfile($RealBin, $logfilename);
	open $logf, ">>$logfile" or die "can't open log file\n";
}

&log("\n\n=================================\n");

my @cmd = ();

sub convert {
	my $str = shift;
	&log("Converted argument: $str ");
	&Encode::from_to($str, $system_encoding, "utf8");
	my ( $hex ) = unpack( 'H*', $str);
	&log("\nto utf8 " . $hex ."\n\n");
	$str;
}

Getopt::Mixed::init ("outfile=s title=s updatedtitle=s prefixtitle=s author=s addauthor=s
    description=s language=s subject=s publisher=s databasename=s patch fiximagesizes
    gen3imagefix exthtype=s addexthtype=s exthdata=s delexthtype=s 
    delexthindex=s booktype=s addthumbnail=s coverimage=s coveroffset=s
    mbpfile=s savecover=s savethumb=s imagerescale=s allowtts deleteclippinglimit imagemaxbytes=s ");

while (($option, $value) = nextOption()) {
	@strs = qw(title updatedtitle prefixtitle author addauthor description language subject publisher databasename 
        exthtype addexthtype exthdata delexthtype delexthindex booktype);
	@bools = qw ( patch fiximagesizes gen3imagefix allowtts deleteclippinglimit);
	my $done = 0;
	&log("$option:" . ($value ? $value: "") . "\n");
	for (@bools) {
		if($option eq $_ ) { 
			push @cmd, "--$_"; 
			&log("Find match option $option.\n");
			$done = 1;
		}
	}
	for (@strs) {
		if($option eq $_ ) { 
			&log("Find match option $option and converted.\n");
			push @cmd, "--$_", &convert($value); 
			$done = 1;
		}
	}
	if($done == 0) {
		push @cmd, "--$option", $value;
		&log("Leave as is: $option and $value\n\n");
	}
    }
Getopt::Mixed::cleanup();

push @cmd, @ARGV;

&log("Argument m2mrun call:\n");
for (@cmd) { &log("\"$_\" "); }
&log("\n");

my $r = &m2mrun::m2mrun(@cmd);

&log("\n\n ----------- Output begins -------------- \n");

for (@$r) {
    chomp;
    if(&mytexttag($_)) {
	    &Encode::from_to($_, "utf8", $system_encoding);
	    &log("Converted GBK: $_\n");
    }

    &log("\t$_\n");
    print "$_\n";
}

sub mytexttag {
	my $t = shift;
	return 1 if $t =~ m/Title/i;
	return 1 if $t =~ m/Author/;
	return 1 if $t =~ m/Contributor/;
	return 1 if $t =~ m/source/i;
	return 1 if $t =~ m/publish/i;
	return 1 if $t =~ m/name/i;
	return 1 if $t =~ m/description/i;
	return 1 if $t =~ m/subject/i;
	return 1 if $t =~ m/contributor/i;
	return 1 if $t =~ m/review/i;
	return 1 if $t =~ m/rights/i;
	return 1 if $t =~ m/type/i;
	return 1 if ($t =~ m/header/i and $t !~ m/^MOBIHEADER/ and $t !~ m/^PDHEADER/);
	return 1 if $t =~ m/StartReading/i;
	return 0;
}
