#!/bin/sh

# udev kills slow scripts
if [ "$SETSID" != "1" ]
then
    SETSID=1 setsid "$0" "$@" &
    exit
fi

# wait for nickel
while sleep 10
do
    pidof nickel && break
done

# udev might call twice
mkdir /tmp/ScreenSaver || exit

# for pickel from nickel
eval $(xargs -0 < /proc/$(pidof nickel)/environ)
export PLATFORM PRODUCT

#identifica o modelo do kobo
case $PRODUCT in
	trilogy) modelo="TouchMini";;
	kraken) modelo="Glo";;
	pixie) modelo="TouchMini";;
	dragon) modelo="AuraHD";;
	dahlia) modelo="AuraH2O";;
	phoenix) modelo="Aura";;
	*) modelo="other";;
esac

# ScreenSaver by waiting for syslog event

PATH="/usr/local/ScreenSaver:$PATH"
ROTATE=/sys/class/graphics/fb0/rotate

logread -f | stdbuf -oL grep '>>> IconPowerView' | while read line
do
    cd /mnt/onboard/.ScreenSaver/$modelo/suspend || exit

    # save rotation
    rotate=$(cat "$ROTATE")

    # show random picture
    set -- *.png
    rnd="$RANDOM$RANDOM$RANDOM"
    file=$(eval 'echo "${'$((1 + $rnd % $#))'}"')
    pngcat "$file" | /usr/local/Kobo/pickel showpic
    pngcat "$file" | /usr/local/Kobo/pickel showpic 1

    # restore rotation
    echo "$rotate" > "$ROTATE"
    cat "$ROTATE" > "$ROTATE"

    cd /
done

rmdir /tmp/ScreenSaver
