# !/bin/sh -e

# Tweak appropriately, I'm assuming it's already mounted rw.
# For ref.: sudo mount -o loop mmcblk0p2.img DIAGS
DIAGS_MOUNTPOINT="./DIAGS"

## Here goes...
fail()
{
	echo "** ${1} **"
	exit 1
}

# Need to be root...
if [[ $(id -u) -ne 0 ]] ; then
	fail "Not running as root!"
fi

echo "Setting diags root password to mario"
echo 'root:$1$szXhciXv$MWycANLcKbEravzSx7sET0:0:0:99999:7:::' > /tmp/shadow.diags
grep -v '^root:' ${DIAGS_MOUNTPOINT}/etc/shadow >> /tmp/shadow.diags || fail "Unable to change diags root password (1)"
cp -f /tmp/shadow.diags ${DIAGS_MOUNTPOINT}/etc/shadow || fail "Unable to change diags root password (2)"
rm -f /tmp/shadow.diags || fail "Unable to change diags root password (3)"

echo "Creating directories"
mkdir -p ${DIAGS_MOUNTPOINT}/usr/local/bin
mkdir -p ${DIAGS_MOUNTPOINT}/usr/local/sbin
mkdir -p ${DIAGS_MOUNTPOINT}/usr/local/etc/dropbear
mkdir -p ${DIAGS_MOUNTPOINT}/etc/dropbear

echo "Copying SSH keys"
cp -f dropbear_*_host_key ${DIAGS_MOUNTPOINT}/usr/local/etc/dropbear/ || fail "Unable to copy SSH keys (1)"
cp -f dropbear_*_host_key ${DIAGS_MOUNTPOINT}/etc/dropbear/ || fail "Unable to copy SSH keys (2)"

echo "Copying binary files"
cp -f dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/bin/ || fail "Unable to copy dropbearmulti"
chmod 755 ${DIAGS_MOUNTPOINT}/usr/local/bin/dropbearmulti || fail "Unable to chmod 755 dropbearmulti"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/bin/dbclient || fail "Unable to link dropbearmulti to dbclient"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/bin/dropbearconvert || fail "Unable to link dropbearmulti to dropbearconvert"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/bin/dropbearkey || fail "Unable to link dropbearmulti to dropbearkey (1)"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/bin/scp || fail "Unable to link dropbearmulti to scp"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/sbin/dropbear || fail "Unable to link dropbearmulti to dropbear"
ln -sf /usr/local/bin/dropbearmulti ${DIAGS_MOUNTPOINT}/usr/local/sbin/dropbearkey || fail "Unable to link dropbearmulti to dropbearkey (2)"

echo "Patching system_diags"
sed -i -e 's/rm -rf \/usr\/local/rm -rf \/DIS\/ABLED/' ${DIAGS_MOUNTPOINT}/opt/factory/system_diags || fail "Unable to patch system_diags"

