# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

from __future__ import unicode_literals, division, absolute_import, print_function

import os
import sys
import inspect
import zipfile

PY2 = sys.version_info[0] == 2

if PY2:
    import Tkinter as tkinter
    import tkFileDialog as tkinter_filedialog
    range = xrange
else:
    import tkinter
    import tkinter.filedialog as tkinter_filedialog

SCRIPT_DIR = os.path.normpath(os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe()))))
PLUGIN_NAME = os.path.split(SCRIPT_DIR)[-1]
PLUG_DIR = os.path.dirname(SCRIPT_DIR)

prefs_one = {}
prefs_two = {}

# Create default settings to use when no preference file exists
# One dictionary for each desired settings "group"
Group1 = {
    'setting1': True,
    'setting2': [1, 2, 3],
}

Group2 = {
    'setting3': '',
    'setting4': os.path.expanduser('~'),
}

def fileChooser():
    localRoot = tkinter.Tk()
    localRoot.withdraw()
    file_opt = {}
    file_opt['parent'] = None
    file_opt['title']= 'Select Kindlebook file'
    file_opt['defaultextension'] = '.azw3'
    # retrieve the initialdir from prefs dictionary
    file_opt['initialdir'] = prefs_two['setting4']
    file_opt['multiple'] = False
    localRoot.quit()
    return tkinter_filedialog.askopenfilename(**file_opt)

def run(bk):
    global prefs_one, prefs_two
    
    # Get preferences from json prefs  
    prefs = bk.getPrefs()
    
    # Or use defaults if json doesn't yet exist (first run, or file deleted).
    # Set each previously defined default grouping dictionary to an entry in
    # the preferences dictionary (dictionary of dictionaries) on for each settings group.
    prefs.defaults['Group1'] = Group1
    prefs.defaults['Group2'] = Group2
    
    # Assign each group to a temporary local dictionary for easier use
    prefs_one = prefs['Group1']
    prefs_two = prefs['Group2']
    
    # Print some settings (either from last run or defaults if never run)
    print ('Last dir (from prefs):', prefs_two['setting4'])
    print ('Last file chosen:', prefs_two['setting3'])
    print ('Random setting:', prefs_one['setting1'])
    for entry in prefs_one['setting2']:
        print('...', entry)
    
    print ('\n')
    
    inpath = fileChooser()
    if inpath == '' or not os.path.exists(inpath):
        raise Exception('No input file selected!')

    print ('New file chosen:', inpath)
    print ('\n')
    
    # Get the directory from the selected file and save it to the preferences dict
    prefs_two['setting4'] = os.path.dirname(inpath)
    # Save file path to preferences dict
    prefs_two['setting3'] = inpath
    # Change the other preferences
    prefs_one['setting1'] = not prefs_one['setting1']
    for x in range(len(prefs_one['setting2'])):
        prefs_one['setting2'][x] += 1
        
    # Copy temp group dictionaries back to main preference dictionary
    prefs['Group1'] = prefs_one
    prefs['Group2'] = prefs_two
    
    # Save prefs to json
    bk.savePrefs(prefs)
    
    # Show where the json file gets written
    json_path = os.path.join(os.path.dirname(PLUG_DIR), 'plugins_prefs', PLUGIN_NAME, '{0}.json'.format(PLUGIN_NAME))
    print ('JSON file saved as:', json_path)
    print ('\n')
    print ('Clicking the "Open Preferences Location" button from Sigil\'s "Edit->Preferences" menu/dialog will get you most of the way there.')

    return 0

def main():
    print ('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
