#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Grant Drake <grant.drake@gmail.com>'
__docformat__ = 'restructuredtext en'

try:
    from PyQt5.Qt import (QVBoxLayout, Qt, QGroupBox, QCheckBox)
except:
    from PyQt4.Qt import (QVBoxLayout, Qt, QGroupBox, QCheckBox)

from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from calibre.utils.config import JSONConfig

STORE_NAME = 'Options'
KEY_GET_GENRE_AS_TAGS = 'getGenreAsTags'
KEY_GET_SUB_GENRES_AS_TAGS = 'getSubGenresAsTags'
KEY_GET_THEMES_AS_TAGS = 'getThemesAsTags'
KEY_GET_TIME_PERIOD_AS_TAGS = 'getTimePeriodAsTags'
KEY_GET_TAGS_AS_TAGS = 'getTagsAsTags'
KEY_GET_AGE_LEVEL_AS_TAGS = 'getAgeLevelAsTags'

DEFAULT_STORE_VALUES = {
    KEY_GET_GENRE_AS_TAGS: True,
    KEY_GET_SUB_GENRES_AS_TAGS: False,
    KEY_GET_THEMES_AS_TAGS: False,
    KEY_GET_TIME_PERIOD_AS_TAGS: False,
    KEY_GET_TAGS_AS_TAGS: False,
    KEY_GET_AGE_LEVEL_AS_TAGS: False
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/FictionDB')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):

    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox('Other options', self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 1, 2)
        other_group_box_layout = QVBoxLayout()
        other_group_box.setLayout(other_group_box_layout)

        self.get_genre_as_tags_checkbox = QCheckBox('Include \'genres\' in the Tags column', self)
        self.get_genre_as_tags_checkbox.setToolTip('When checked if a book has any genres defined they will be\n'
                                                   'returned in the Tags column from this plugin.')
        self.get_genre_as_tags_checkbox.setChecked(c[KEY_GET_GENRE_AS_TAGS])
        other_group_box_layout.addWidget(self.get_genre_as_tags_checkbox)

        self.get_sub_genres_as_tags_checkbox = QCheckBox('Include \'sub-genres\' in the Tags column', self)
        self.get_sub_genres_as_tags_checkbox.setToolTip('When checked if a book has any sub-genres defined they will be\n'
                                                        'returned in the Tags column from this plugin.')
        self.get_sub_genres_as_tags_checkbox.setChecked(c[KEY_GET_SUB_GENRES_AS_TAGS])
        other_group_box_layout.addWidget(self.get_sub_genres_as_tags_checkbox)

        self.get_themes_as_tags_checkbox = QCheckBox('Include \'themes\' in the Tags column', self)
        self.get_themes_as_tags_checkbox.setToolTip('When checked if a book has any themes defined it will be\n'
                                                         'returned in the Tags column from this plugin.')
        self.get_themes_as_tags_checkbox.setChecked(c.get(KEY_GET_THEMES_AS_TAGS, False))
        other_group_box_layout.addWidget(self.get_themes_as_tags_checkbox)

        self.get_time_period_as_tags_checkbox = QCheckBox('Include \'time period\' in the Tags column', self)
        self.get_time_period_as_tags_checkbox.setToolTip('When checked if a book has any time period defined it will be\n'
                                                         'returned in the Tags column from this plugin.')
        self.get_time_period_as_tags_checkbox.setChecked(c[KEY_GET_TIME_PERIOD_AS_TAGS])
        other_group_box_layout.addWidget(self.get_time_period_as_tags_checkbox)

        self.get_tags_as_tags_checkbox = QCheckBox('Include \'tags\' in the Tags column', self)
        self.get_tags_as_tags_checkbox.setToolTip('When checked if a book has any tags defined they will be\n'
                                                  'returned in the Tags column from this plugin.')
        self.get_tags_as_tags_checkbox.setChecked(c[KEY_GET_TAGS_AS_TAGS])
        other_group_box_layout.addWidget(self.get_tags_as_tags_checkbox)

        self.get_age_level_as_tags_checkbox = QCheckBox('Include \'age level\' in the Tags column', self)
        self.get_age_level_as_tags_checkbox.setToolTip('When checked if a book has any age level defined they will be\n'
                                                  'returned in the Tags column from this plugin.')
        self.get_age_level_as_tags_checkbox.setChecked(c[KEY_GET_AGE_LEVEL_AS_TAGS])
        other_group_box_layout.addWidget(self.get_age_level_as_tags_checkbox)

    def commit(self):
        DefaultConfigWidget.commit(self)

        new_prefs = {}
        new_prefs[KEY_GET_GENRE_AS_TAGS] = self.get_genre_as_tags_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_SUB_GENRES_AS_TAGS] = self.get_sub_genres_as_tags_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_THEMES_AS_TAGS] = self.get_themes_as_tags_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_TIME_PERIOD_AS_TAGS] = self.get_time_period_as_tags_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_TAGS_AS_TAGS] = self.get_tags_as_tags_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_AGE_LEVEL_AS_TAGS] = self.get_age_level_as_tags_checkbox.checkState() == Qt.Checked
        plugin_prefs[STORE_NAME] = new_prefs

