#!/bin/sh

usage=$(basename $0)

if [ "$usage" == "autoshelf.sh" ]; then
 # [ $(pidof nickel | wc -c) == 0 ] && exit
    PATH="/usr/local/AutoShelf":"$PATH"
    sqlite3prg=/usr/local/AutoShelf/sqlite3
else
    #KSM specific
    ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}
    targetmd5sum=$ksmroot/log/autoshelf_md5sum
    sqlite3prg=$ksmroot/tools/sqlite3
fi

udev_workarounds() {
# udev kills slow scripts
    if [ "$SETSID" != "1" ]
    then
        SETSID=1 setsid "$0" "$@" &
        exit
    fi
}

suspend_nickel() {
    mkdir /tmp/suspend-nickel && (
    pkill -SIGSTOP nickel
    cat /sys/class/graphics/fb0/rotate > /tmp/rotate-nickel
    nice /etc/init.d/on-animator.sh &
    )
    mkdir /tmp/suspend-nickel/"$1" || exit
}

resume_nickel() {
    rmdir /tmp/suspend-nickel/"$1"
    rmdir /tmp/suspend-nickel && (
    killall on-animator.sh pickle
    cat /tmp/rotate-nickel > /sys/class/graphics/fb0/rotate
    cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate # 180° fix
    pkill -SIGCONT nickel
    )
}

filesystem() {
    find /mnt/ -not -path '*/\.*' | sort
}

autoshelf() {
    echo "PRAGMA synchronous = OFF;"
    echo "PRAGMA journal_mode = MEMORY;"
    echo "BEGIN TRANSACTION;"

    echo "DELETE FROM Shelf WHERE InternalName LIKE '%/';"
    echo "DELETE FROM ShelfContent WHERE ShelfName LIKE '%/';"

    i=0

    $sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite "
    SELECT ContentID FROM content
    WHERE ContentID LIKE 'file:///mnt/%'
    AND ContentID NOT LIKE '%#%'
    AND ContentID NOT LIKE '%/.%'
    AND ContentType != 9
    ORDER BY ContentID
    ;" | while read file
do
    i=$(($i+1))
    date="strftime('%Y-%m-%dT%H:%M:%SZ','now','-$i minute')"
    file=$(echo "$file" | sed -e "s@'@''@g")
    shelf=$(dirname "$file" | sed -r -e 's@^file://*mnt//*(onboard|sd)/*@@')
    word=$(basename "$file")
    for number in $word; do break; done
        if [ "$shelf" == "" ]
        then
            series="$word"
        else
            series="$shelf"
        fi

        if [ "$shelf" != "$prevshelf" ]
        then
            prevshelf="$shelf"
            echo "REPLACE INTO Shelf VALUES($date,'$shelf/','$shelf/',$date,'$shelf/',NULL,'false','true','false');"
        fi

        echo "INSERT INTO ShelfContent VALUES('$shelf/','$file',$date,'false','false');"

        echo "
        UPDATE content
        SET Series='$series', SeriesNumber='$number', DateCreated=$date, DateAdded=$date
        WHERE ContentID='$file'
        ;"
    done

    echo "END TRANSACTION;"
}

if [ "$usage" == "autoshelf.sh" ]; then
    udev_workarounds

    suspend_nickel autoshelf

    for i in $(seq 1 10)
    do
        if [ -e /mnt/onboard/.kobo/KoboReader.sqlite ]
        then
            break
        fi

        sleep 1
    done
fi

if [ -e /mnt/onboard/.kobo/KoboReader.sqlite ]
then
    if [ "$usage" == "autoshelf.sh" ]; then
        result=$(autoshelf)
        if echo "$result" | md5sum -c /usr/local/AutoShelf/md5sum
        then
            echo "Already done..."
        else
            echo "Updating database..."
            echo "$result" | md5sum > /usr/local/AutoShelf/md5sum
            echo "$result" | sqlite3 /mnt/onboard/.kobo/KoboReader.sqlite
        fi
    else
        #KSM specific
        /etc/init.d/update-animator.sh &
        result=$(autoshelf)
        if echo "$result" | md5sum -c $targetmd5sum > /dev/null 2>&1
        then
            echo "Already done..."
        else
            echo "$result" | md5sum > $targetmd5sum
            echo "$result" | $sqlite3prg /mnt/onboard/.kobo/KoboReader.sqlite  > /dev/null 2>&1
            echo "Database updated..."
        fi
        killall update-animator.sh
    fi
fi

if [ "$usage" == "autoshelf.sh" ]; then
    resume_nickel autoshelf
fi
