#!/bin/sh
ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}
if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
  sh $ksmroot/kbmessage.sh "Please handle your update files!"
  exit
fi

sh $ksmroot/onstart/feedfmon.sh
( usleep 400000; /etc/init.d/on-animator.sh ) &

(
/usr/local/Kobo/pickel disable.rtc.alarm

if [ ! -e /etc/wpa_supplicant/wpa_supplicant.conf ]; then
  cp /etc/wpa_supplicant/wpa_supplicant.conf.template /etc/wpa_supplicant/wpa_supplicant.conf
fi

echo 1 > /sys/devices/platform/mxc_dvfs_core.0/enable

/sbin/hwclock -s -u
) &

currentRotation=$(cat /sys/class/graphics/fb0/rotate)

export NICKEL_HOME=/mnt/onboard/.kobo
export LD_LIBRARY_PATH=/usr/local/Kobo

grep -qs '/mnt/sd' /proc/mounts && echo sd add /dev/mmcblk1p1 >> /tmp/nickel-hardware-status &



/usr/local/Kobo/hindenburg &
lsmod | grep -q lowmem || insmod /drivers/$PLATFORM/misc/lowmem.ko &
[ `cat /mnt/onboard/.kobo/Kobo/Kobo\ eReader.conf | grep -c dhcpcd=true` == 1 ] && dhcpcd -d -t 10 &
/usr/local/Kobo/nickel -platform kobo -skipFontLoad

echo "$currentRotation" > /sys/class/graphics/fb0/rotate
cat /sys/class/graphics/fb0/rotate > /sys/class/graphics/fb0/rotate
