import os
from calibre.customize import FileTypePlugin

class AmazonTitleSeries(FileTypePlugin):

    name                = 'Amazon Title Series' # Name of the plugin
    description         = 'Fix title and series on amazon books'
    supported_platforms = ['windows', 'osx', 'linux'] # Platforms this plugin will run on
    author              = 'L Roe' # The author of this plugin
    version             = (1, 0, 0)   # The version number of this plugin
    file_types          = set(['azw3']) # The file types that this plugin will be applied to
    #on_postprocess      = True # Run this plugin after conversion is complete
    on_postimport       = True # run after books are added to the database
    #on_import               = True #run when books are added to the database
    minimum_calibre_version = (0, 7, 53)
    priority                = 601

    def run(self, path_to_ebook):
        from calibre.ebooks.metadata.meta import get_metadata, set_metadata
        print '--------------------begin AmazonTitleSeries--------------------'
        return path_to_ebook
        file = open(path_to_ebook, 'r+b')
        ext  = os.path.splitext(path_to_ebook)[-1][1:].lower()
        mi = get_metadata(file, ext)
        title=mi.title
        print('title:' + title)
        p=title.find('(')
        print p
        if p>=0:
            print 'formatting title'
            series=title[p+1:]
            print 'series:'+series
            mi.series=series
        set_metadata(file, mi, ext)
        print '--------------------end AmazonTitleSeries--------------------'
        return path_to_ebook
    def postimport(self, book_id, book_format, db):
        print '--------------------begin AmazonTitleSeries--------------------'
        print book_id + ' ' + book_format
        print '--------------------end AmazonTitleSeries--------------------'
