#!/bin/sh
ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}

if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
  sh $ksmroot/kbmessage.sh "Please handle your update files!"
  exit
fi

kbmenuonstartdir=$ksmroot/onstart

tempdir=/tmp/kbmenu
nkloopfifo=$tempdir/nkloopfifo
mkdir -p $tempdir
mkfifo $nkloopfifo
currentRotation=$(cat /sys/class/graphics/fb0/rotate)
while :
do
  if [ -p "$nkloopfifo" ]; then
    sh $kbmenuonstartdir/koreader_kobo.sh
  else
    exit
  fi
  sh $kbmenuonstartdir/startreader_fromloop.sh
  echo "$currentRotation" > /sys/class/graphics/fb0/rotate
done
