#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

from __future__ import unicode_literals, division, absolute_import, print_function

__path__ = ["libgui", "."]

import sys
import os
import re

PY2 = sys.version_info[0] == 2

if PY2 and sys.platform.startswith("win"):
    from .askfolder_ed import AskFolder

if PY2:
    import Tkinter as tkinter
    import ttk as tkinter_ttk
    import Tkconstants as tkinter_constants
    import tkFileDialog as tkinter_filedialog
else:
    import tkinter
    import tkinter.ttk as tkinter_ttk
    import tkinter.constants as tkinter_constants
    import tkinter.filedialog as tkinter_filedialog


from .user_utilities import expanduser
USER_HOME = expanduser("~")


# borrowed/modified from calibre from calibre/src/calibre/__init__.py
def cleanupFilename(name):
    import string
    _filename_sanitize = re.compile(r'[\xae\0\\|\?\*<":>\+/]')
    substitute='_'
    one = ''.join(char for char in name if char in string.printable)
    one = _filename_sanitize.sub(substitute, one)
    one = re.sub(r'\s', '_', one).strip()
    one = re.sub(r'^\.+$', '_', one)
    one = one.replace('..', substitute)
    # Windows doesn't like path components that end with a period
    if one.endswith('.'):
        one = one[:-1]+substitute
    # Mac and Unix don't like file names that begin with a full stop
    if len(one) > 0 and one[0:1] == '.':
        one = substitute+one[1:]
    return one


def fileSaveAs(title, template_filename_with_ext, starting_folder):
    file_basename, file_ext = os.path.splitext(template_filename_with_ext)
    localRoot = tkinter.Tk()
    localRoot.withdraw()
    file_opt = {}
    file_opt['parent'] = localRoot
    file_opt['title'] = title
    file_opt['initialfile'] = template_filename_with_ext
    file_opt['initialdir'] = starting_folder
    file_opt['defaultextension'] = file_ext
    fpath = tkinter_filedialog.asksaveasfilename(**file_opt)
    localRoot.destroy()
    # localRoot.quit()
    return fpath


# sample filetype: [('Kindlebooks', ('.azw', '.azw3', '.prc', '.mobi'))]
def fileChooser(title, default_extension, starting_folder, file_types):
    localRoot = tkinter.Tk()
    localRoot.withdraw()
    file_opt = {}
    file_opt['parent'] = localRoot
    file_opt['title']= title
    file_opt['defaultextension'] = default_extension
    file_opt['initialdir'] = starting_folder
    file_opt['multiple'] = False
    file_opt['filetypes'] = file_types
    fpath = tkinter_filedialog.askopenfilename(**file_opt) 
    localRoot.destroy()
    # localRoot.quit()
    return fpath


def folderChooser(title, starting_folder):
    if sys.platform.startswith("win") and PY2:
        foldpath =  AskFolder(message=title, defaultLocation=starting_folder)
        return foldpath
    localRoot = tkinter.Tk()
    localRoot.withdraw()
    fold_opt = {}
    fold_opt['parent'] = localRoot
    fold_opt['title'] = title
    fold_opt['initialdir'] = starting_folder
    fold_opt['initialfile'] = None
    foldpath = tkinter_filedialog.askdirectory(**fold_opt)
    localRoot.destroy()
    # localRoot.quit()
    return foldpath


def selectFromList(title, list):
    selected = []
    localRoot = tkinter.Tk()
    ls = ListSelection(localRoot, title, list)
    ls.pack(side="top", fill="both", expand=True)
    localRoot.withdraw()
    localRoot.update_idletasks()
    x = (localRoot.winfo_screenwidth() - localRoot.winfo_reqwidth()) // 2
    y = (localRoot.winfo_screenheight() - localRoot.winfo_reqheight()) // 2
    localRoot.geometry("+%d+%d" % (x,y))
    localRoot.deiconify()
    localRoot.mainloop()
    # exits with quit but don't destroy until after read out selections
    for (name, cb, sv) in ls.cblist:
        if sv.get() == 1:
            selected.append(name)
    localRoot.destroy()
    return selected


class ListSelection(tkinter.Frame):
    def __init__(self, root, title, list):
        tkinter.Frame.__init__(self, root)
        self.root = root
        self.list = list
        self.title = title
        sticky = tkinter_constants.E + tkinter_constants.W
        ALL = tkinter_constants.E+tkinter_constants.W+tkinter_constants.N+tkinter_constants.S
        self.grid_columnconfigure(2, weight=1)
        self.grid_rowconfigure(24, weight=1)
        tkinter.Label(self, text=title).grid(row=0, columnspan=3, sticky=tkinter_constants.W)
        allbutton = tkinter.Button(self, text="Select All", command=self.select_all)
        clrbutton = tkinter.Button(self, text="Clear All", command=self.clear_all)
        donbutton = tkinter.Button(self, text="Done", command=self.quit)
        allbutton.grid(row=1, column=0, sticky=sticky)
        clrbutton.grid(row=1, column=1, sticky=sticky)
        donbutton.grid(row=1, column=2, sticky=sticky)
        lcb = tkinter.Frame(self)
        lcb.vsb = tkinter.Scrollbar(lcb, orient="vertical")
        lcb.text = tkinter.Text(lcb, width=40, height=20, yscrollcommand=lcb.vsb.set)
        lcb.vsb.config(command=lcb.text.yview)
        lcb.vsb.pack(side="right", fill="y")
        lcb.text.pack(side="left", fill="both", expand=True)
        self.cblist = []
        for name in list:
            sv = tkinter.IntVar()
            cb = tkinter.Checkbutton(lcb, text=name, variable=sv)
            self.cblist.append((name, cb, sv))
            lcb.text.window_create("end", window=cb)
            lcb.text.insert("end", "\n") # to force one checkbox per line
        lcb.grid(row=3, rowspan=20, columnspan=3, sticky=sticky)

    def select_all(self):
        for (name, cb, sv) in self.cblist:
            cb.select()

    def clear_all(self):
        for (name, cb, sv) in self.cblist:
            cb.deselect()


def main():

    inlist=["hello",  "goodby", "junk01", "junk02", "junk03", "junk04", "junk5",
          "junk06", "junk07", "junk08", "junk09", "junk10", "junk11", "junk12",
          "junk13", "junk14", "junk15", "junk16", "junk17", "junk18", "junk19", 
          "junk20", "junk21", "junk22", "junk23", "junk24", "junk25", "junk26", 
          "junk27", "junk28", "junk29", "junk30"]

    my_selections = selectFromList("Select From My Test ListList",inlist)
    print(my_selections)

    filepath = fileSaveAs("Testing File Save As", "filename.epub", USER_HOME)
    print(filepath)

    file_types =  [('Epub Ebooks', ('.epub', '.epub2', '.epub3'))]
    filepath = fileChooser("Testing Select an existing File", ".epub", USER_HOME, file_types)
    print(filepath)

    folder_path = folderChooser("Testing Select a Folder", USER_HOME)
    print(folder_path)

    return 0
    
if __name__ == "__main__":
    sys.exit(main())

