#!/bin/sh

ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}
fbrotatevalue=${fbrotatevalue:-"0"}

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=/mnt/onboard/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  actualrotatevalue=$(cat /sys/class/graphics/fb0/rotate)
  echo "actualrotatevalue: $actualrotatevalue" >> $debug_logfile
  echo "inheritedrotatevalue: $fbrotatevalue" >> $debug_logfile
fi

echo "$fbrotatevalue" > /sys/class/graphics/fb0/rotate

if [ "$KSMdebugmode" == "true" ]; then
  setrotatevalue=$(cat /sys/class/graphics/fb0/rotate)
  echo "setrotatevalue: $setrotatevalue" >> $debug_logfile
  sync
fi

sh $ksmroot/kbmessage.sh "-f $ksmroot/txt/poweroff_info.html" &
usleep 400000
/bin/busybox poweroff
